% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FeatureSetCommon.R
\name{FeatureSetCommon}
\alias{FeatureSetCommon}
\title{Class containing functionality common to \code{\link{FeatureSet}}s and
  \code{\link{ReconstructedFeatureSet}}s}
\description{
An FeatureSetCommon has functionality for retrieving
  sets of features (e.g. points or landmarks associated with an
  outline)
}
\author{
David Sterratt
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{data}}{List of matrices describing data}

\item{\code{cols}}{Vector of colours for each data set}

\item{\code{type}}{String giving type of feature set}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-getIndex}{\code{FeatureSetCommon$getIndex()}}
\item \href{#method-getIDs}{\code{FeatureSetCommon$getIDs()}}
\item \href{#method-setID}{\code{FeatureSetCommon$setID()}}
\item \href{#method-getFeature}{\code{FeatureSetCommon$getFeature()}}
\item \href{#method-getFeatures}{\code{FeatureSetCommon$getFeatures()}}
\item \href{#method-getCol}{\code{FeatureSetCommon$getCol()}}
\item \href{#method-clone}{\code{FeatureSetCommon$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-getIndex"></a>}}
\subsection{Method \code{getIndex()}}{
Get numeric index of features
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FeatureSetCommon$getIndex(fid)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{fid}}{Feature ID (string)}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-getIDs"></a>}}
\subsection{Method \code{getIDs()}}{
Get IDs of features
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FeatureSetCommon$getIDs()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Vector of IDs of features
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-setID"></a>}}
\subsection{Method \code{setID()}}{
Set name
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FeatureSetCommon$setID(i, fid)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{i}}{Numeric index of feature}

\item{\code{fid}}{Feature ID (string)}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-getFeature"></a>}}
\subsection{Method \code{getFeature()}}{
Get feature by feature ID
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FeatureSetCommon$getFeature(fid)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{fid}}{Feature ID string}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Matrix describing feature
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-getFeatures"></a>}}
\subsection{Method \code{getFeatures()}}{
Get all features
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FeatureSetCommon$getFeatures()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-getCol"></a>}}
\subsection{Method \code{getCol()}}{
Get colour in which to plot feature ID
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FeatureSetCommon$getCol(fid)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{fid}}{Feature ID string}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FeatureSetCommon$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
