% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distributions.R
\name{gev}
\alias{gev}
\alias{dgev}
\alias{pgev}
\alias{qgev}
\alias{rgev}
\title{The Generalised Extreme Value Distribution}
\usage{
dgev(x, loc = 0, scale = 1, shape = 0, log = FALSE)

pgev(q, loc = 0, scale = 1, shape = 0, lower_tail = TRUE)

qgev(p, loc = 0, scale = 1, shape = 0, lower_tail = TRUE)

rgev(n, loc = 0, scale = 1, shape = 0)
}
\arguments{
\item{x, q}{Numeric vectors of quantiles.}

\item{loc, scale, shape}{Numeric vectors.
Location, scale and shape parameters.
All elements of \code{scale} must be positive.
In \code{dgev}, \code{pgev} and \code{qgev} these vectors can have
length > 1, but only if \code{length(x)[dgev]}, \code{length(q)[pgev]},
or \code{length(p)[qgev]} has length one.
Then they must either have a common length or a subset of
them must have a common length with the others having length one.
Otherwise, they must have length one.}

\item{log}{A logical scalar.  If TRUE the log-density is returned.}

\item{lower_tail}{A logical scalar.  If TRUE (default), probabilities
are P[X <= x], otherwise, P[X > x].}

\item{p}{A numeric vector of probabilities in [0,1].}

\item{n}{Numeric scalar.  The number of observations to be simulated.}
}
\value{
\code{dgev} gives the density function, \code{pgev} gives the
  distribution function, \code{qgev} gives the quantile function,
  and \code{rgev} generates random deviates.
}
\description{
Density function, distribution function, quantile function and
random generation for the generalised extreme value (GEV)
distribution.
}
\details{
The distribution function of a GEV distribution with parameters
 \code{loc} = \eqn{\mu}, \code{scale} = \eqn{\sigma} (>0) and
 \code{shape} = \eqn{\xi} is
 \deqn{F(x) = exp { - [1 + \xi (x - \mu) / \sigma] ^ (-1/\xi)} }
 for \eqn{1 + \xi (x - \mu) / \sigma > 0}.  If \eqn{\xi = 0} the
 distribution function is defined as the limit as \eqn{\xi} tends to zero.
 The support of the distribution depends on \eqn{\xi}: it is
 \eqn{x <= \mu - \sigma / \xi} for \eqn{\xi < 0};
 \eqn{x >= \mu - \sigma / \xi} for \eqn{\xi > 0};
 and \eqn{x} is unbounded for \eqn{\xi = 0}.
 Note that if \eqn{\xi < -1} the GEV density function becomes infinite
 as \eqn{x} approaches \eqn{\mu -\sigma/\xi} from below.

 If \code{lower_tail = TRUE} then if \code{p = 0} (\code{p = 1}) then
 the lower (upper) limit of the distribution is returned, which is
 \code{-Inf} or \code{Inf} in some cases.  Similarly, but reversed,
 if \code{lower_tail = FALSE}.

 See
 \url{https://en.wikipedia.org/wiki/Generalized_extreme_value_distribution}
 for further information.
}
\examples{
dgev(-1:4, 1, 0.5, 0.8)
dgev(1:6, 1, 0.5, -0.2, log = TRUE)
dgev(1, shape = c(-0.2, 0.4))

pgev(-1:4, 1, 0.5, 0.8)
pgev(1:6, 1, 0.5, -0.2)
pgev(1, c(1, 2), c(1, 2), c(-0.2, 0.4))
pgev(-3, c(1, 2), c(1, 2), c(-0.2, 0.4))
pgev(7, 1, 1, c(-0.2, 0.4))

qgev((1:9)/10, 2, 0.5, 0.8)
qgev(0.5, c(1,2), c(0.5, 1), c(-0.5, 0.5))

p <- (1:9)/10
pgev(qgev(p, 1, 2, 0.8), 1, 2, 0.8)

rgev(6, 1, 0.5, 0.8)
}
\references{
Jenkinson, A. F. (1955) The frequency distribution of the
  annual maximum (or minimum) of meteorological elements.
  \emph{Quart. J. R. Met. Soc.}, \strong{81}, 158-171.
  Chapter 3: \url{http://dx.doi.org/10.1002/qj.49708134804}

Coles, S. G. (2001) \emph{An Introduction to Statistical
  Modeling of Extreme Values}, Springer-Verlag, London.
  \url{http://dx.doi.org/10.1007/978-1-4471-3675-0_3}
}
