% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/priors.R
\name{gev_flat}
\alias{gev_flat}
\title{Flat prior for GEV parameters (\eqn{\mu, log \sigma, \xi})}
\usage{
gev_flat(pars, min_xi = -Inf, max_xi = Inf, trendsd = 0)
}
\arguments{
\item{pars}{A numeric vector of length 3.
GEV parameters (\eqn{\mu, \sigma, \xi}).}

\item{min_xi}{A numeric scalar.  Prior lower bound on \eqn{\xi}.
Must not be \code{-Inf} because this results in an improper posterior.}

\item{max_xi}{A numeric scalar.  Prior upper bound on \eqn{\xi}.}

\item{trendsd}{Has no function other than to achieve compatability with
function in the evdbayes package.}
}
\value{
The log of the prior density.
}
\description{
For information about this and other priors see \code{\link{set_prior}}.
}
