% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distributions.R
\name{gev}
\alias{gev}
\alias{dgev}
\alias{pgev}
\alias{qgev}
\alias{rgev}
\title{The Generalised Extreme Value Distribution}
\usage{
dgev(x, loc = 0, scale = 1, shape = 0, log = FALSE, m = 1)

pgev(q, loc = 0, scale = 1, shape = 0, lower.tail = TRUE,
  log.p = FALSE, m = 1)

qgev(p, loc = 0, scale = 1, shape = 0, lower.tail = TRUE,
  log.p = FALSE, m = 1)

rgev(n, loc = 0, scale = 1, shape = 0, m = 1)
}
\arguments{
\item{x, q}{Numeric vectors of quantiles.}

\item{loc, scale, shape}{Numeric vectors.
Location, scale and shape parameters.
All elements of \code{scale} must be positive.}

\item{log, log.p}{A logical scalar; if TRUE, probabilities p are given as
log(p).}

\item{m}{A numeric scalar.  The distribution is reparameterised by working
with the GEV(\code{loc, scale, shape}) distribution function raised to the
power \code{m}.  See \strong{Details}.}

\item{lower.tail}{A logical scalar.  If TRUE (default), probabilities
are P[X <= x], otherwise, P[X > x].}

\item{p}{A numeric vector of probabilities in [0,1].}

\item{n}{Numeric scalar.  The number of observations to be simulated.
If \code{length(n) > 1} then \code{length(n)} is taken to be the number
required.}
}
\value{
\code{dgev} gives the density function, \code{pgev} gives the
  distribution function, \code{qgev} gives the quantile function,
  and \code{rgev} generates random deviates.

  The length of the result is determined by \code{n} for \code{rgev},
  and is the maximum of the lengths of the numerical arguments for the
  other functions.

  The numerical arguments other than \code{n} are recycled to the length
  of the result.
}
\description{
Density function, distribution function, quantile function and
random generation for the generalised extreme value (GEV)
distribution.
}
\details{
The distribution function of a GEV distribution with parameters
 \code{loc} = \eqn{\mu}, \code{scale} = \eqn{\sigma} (>0) and
 \code{shape} = \eqn{\xi} is
 \deqn{F(x) = exp { - [1 + \xi (x - \mu) / \sigma] ^ (-1/\xi)} }
 for \eqn{1 + \xi (x - \mu) / \sigma > 0}.  If \eqn{\xi = 0} the
 distribution function is defined as the limit as \eqn{\xi} tends to zero.
 The support of the distribution depends on \eqn{\xi}: it is
 \eqn{x <= \mu - \sigma / \xi} for \eqn{\xi < 0};
 \eqn{x >= \mu - \sigma / \xi} for \eqn{\xi > 0};
 and \eqn{x} is unbounded for \eqn{\xi = 0}.
 Note that if \eqn{\xi < -1} the GEV density function becomes infinite
 as \eqn{x} approaches \eqn{\mu -\sigma / \xi} from below.

 If \code{lower.tail = TRUE} then if \code{p = 0} (\code{p = 1}) then
 the lower (upper) limit of the distribution is returned, which is
 \code{-Inf} or \code{Inf} in some cases.  Similarly, but reversed,
 if \code{lower.tail = FALSE}.

 See
 \url{https://en.wikipedia.org/wiki/Generalized_extreme_value_distribution}
 for further information.

 The effect of \code{m} is to change the location, scale and shape
 parameters to
 \eqn{(\mu + \sigma log m, \sigma, \xi)} if \eqn{\xi = 0} and
 \eqn{(\mu + \sigma (m ^ \xi - 1) / \xi, \sigma m ^ \xi, \xi)}.
 For integer \code{m} we can think of this as working with the
 maximum of \code{m} independent copies of the original
 GEV(\code{loc, scale, shape}) variable.
}
\examples{
dgev(-1:4, 1, 0.5, 0.8)
dgev(1:6, 1, 0.5, -0.2, log = TRUE)
dgev(1, shape = c(-0.2, 0.4))

pgev(-1:4, 1, 0.5, 0.8)
pgev(1:6, 1, 0.5, -0.2)
pgev(1, c(1, 2), c(1, 2), c(-0.2, 0.4))
pgev(-3, c(1, 2), c(1, 2), c(-0.2, 0.4))
pgev(7, 1, 1, c(-0.2, 0.4))

qgev((1:9)/10, 2, 0.5, 0.8)
qgev(0.5, c(1,2), c(0.5, 1), c(-0.5, 0.5))

p <- (1:9)/10
pgev(qgev(p, 1, 2, 0.8), 1, 2, 0.8)

rgev(6, 1, 0.5, 0.8)
}
\references{
Jenkinson, A. F. (1955) The frequency distribution of the
  annual maximum (or minimum) of meteorological elements.
  \emph{Quart. J. R. Met. Soc.}, \strong{81}, 158-171.
  Chapter 3: \url{http://dx.doi.org/10.1002/qj.49708134804}

Coles, S. G. (2001) \emph{An Introduction to Statistical
  Modeling of Extreme Values}, Springer-Verlag, London.
  \url{http://dx.doi.org/10.1007/978-1-4471-3675-0_3}
}
