% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kgaps.R
\name{kgaps_mle}
\alias{kgaps_mle}
\title{Maximum likelihood estimation for the K-gaps model}
\usage{
kgaps_mle(data, thresh, k = 1, inc_cens = FALSE, conf = NULL)
}
\arguments{
\item{data}{A numeric vector of raw data.  No missing values are allowed.}

\item{thresh}{A numeric scalar.  Extreme value threshold applied to data.}

\item{k}{A numeric scalar.  Run parameter \eqn{K}, as defined in Suveges and
Davison (2010).  Threshold inter-exceedances times that are not larger
than \code{k} units are assigned to the same cluster, resulting in a
\eqn{K}-gap equal to zero.  Specifically, the \eqn{K}-gap \eqn{S}
corresponding to an inter-exceedance time of \eqn{T} is given by
\eqn{S = max(T - K, 0)}.}

\item{inc_cens}{A logical scalar indicating whether or not to include
contributions from censored inter-exceedance times relating to the
first and last observation.  See Attalides (2015) for details.}

\item{conf}{A numeric scalar.  If \code{conf} is supplied then a
\code{conf}\% likelihood-based confidence interval for \eqn{\theta} is
estimated.}
}
\value{
A list containing
  \itemize{
    \item {\code{theta_mle} : } {The maximum likelihood estimate (MLE) of
      \eqn{\theta}.}
    \item {\code{theta_se} : } {The estimated standard error of the MLE.}
    \item {\code{theta_ci} : } {(If \code{conf} is supplied) a numeric
      vector of length two giving lower and upper confidence limits for
      \eqn{\theta}.}
    \item {\code{ss} : } {The list of summary statistics returned from
      \code{\link{kgaps_stats}}.}
  }
}
\description{
Calculates maximum likelihood estimates of the extremal index \eqn{\theta}
based on the K-gaps model for threshold inter-exceedances times of
Suveges and Davison (2010).
}
\details{
The maximum likelihood estimate of the extremal index \eqn{\theta}
  under the K-gaps model of Suveges and Davison (2010) is calculated.
  If \code{inc_cens = TRUE} then information from censored inter-exceedance
  times is included in the likelihood to be maximised, following
  Attalides (2015).  The form of the log-likelihood is given in the
  \strong{Details} section of \code{\link{kgaps_stats}}.
}
\examples{
thresh <- quantile(newlyn, probs = 0.90)
# MLE and SE only
kgaps_mle(newlyn, thresh)
# MLE, SE and 95\% confidence interval
kgaps_mle(newlyn, thresh, conf = 95)
}
\references{
Suveges, M. and Davison, A. C. (2010) Model
  misspecification in peaks over threshold analysis, \emph{The Annals of
  Applied Statistics}, \strong{4}(1), 203-221.
  \url{https://doi.org/10.1214/09-AOAS292}

Attalides, N. (2015) Threshold-based extreme value modelling,
  PhD thesis, University College London.
  \url{http://discovery.ucl.ac.uk/1471121/1/Nicolas_Attalides_Thesis.pdf}
}
\seealso{
\code{\link{kgaps_stats}} for the calculation of sufficient
  statistics for the K-gaps model.
}
