% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/frequentist.R
\name{gp_lrs}
\alias{gp_lrs}
\title{Linear Combinations of Ratios of Spacings estimation of generalised Pareto
parameters}
\usage{
gp_lrs(x)
}
\arguments{
\item{x}{A numeric vector containing only \strong{positive} values, assumed
to be a random sample from a generalized Pareto distribution.}
}
\value{
A numeric vector of length 2.  The estimates of the scale parameter
  \eqn{\sigma} and the shape parameter \eqn{\xi}.
}
\description{
Uses the Linear Combinations of Ratios of Spacings (LRS) methodology of
(Reiss and Thomas, 2007, page 134) to estimate the parameters of the
generalised Pareto (GP) distribution, based on a sample of positive values.
}
\examples{
u <- quantile(gom, probs = 0.65)
gp_lrs((gom - u)[gom > u])
}
\references{
Reiss, R.-D., Thomas, M. (2007) Statistical Analysis of
  Extreme Values with Applications to Insurance, Finance, Hydrology and
  Other Fields.Birkhauser.
  \doi{10.1007/978-3-7643-7399-3}.
}
\seealso{
\code{\link{gp}} for details of the parameterisation of the GP
  distribution.
}
