% Generated by roxygen2 (4.0.2.9000): do not edit by hand
% Please edit documentation in R/capture.R
\name{capture}
\alias{.}
\alias{capture}
\alias{capture_group}
\title{Create a capture group}
\usage{
capture(..., name = NULL)

capture_group(name)
}
\arguments{
\item{...}{\code{\link{shortcuts}}, R variables, text, or other \pkg{rex}
functions.}

\item{name}{of the group.  Unnamed capture groups are numbers starting at 1
in the order they appear in the regular expression.  If two groups have the
same name, the leftmost group is the used in any reference.}
}
\description{
Used to save the matched value within the group for use later in the regular
expression or to extract the values captured.  Both named and unnamed groups
can later be referenced using \code{\link{capture_group}}.
}
\examples{
# Match paired quotation marks
re <- rex(
  # first quotation mark
  capture(quotes),

  # match all non-matching quotation marks
  zero_or_more(except(capture_group(1))),

  # end quotation mark (matches first)
  capture_group(1)
)

#named capture - don't match apples to oranges
re <- rex(
  capture(name = "fruit", or("apple", "orange")),
  "=",
  capture_group("fruit")
)
}
\seealso{
\code{\link{group}} for grouping without capturing.  Perl 5 Capture
Groups \url{http://perldoc.perl.org/perlre.html#Capture-groups}

Other rex: \code{\link{\%if_next_is\%}},
  \code{\link{\%if_next_isnt\%}},
  \code{\link{\%if_prev_is\%}},
  \code{\link{\%if_prev_isnt\%}},
  \code{\link{lookarounds}}; \code{\link{\%or\%}},
  \code{\link{or}}; \code{\link{any_of}},
  \code{\link{character_class}}, \code{\link{except}},
  \code{\link{except_any_of}},
  \code{\link{except_some_of}},
  \code{\link{exclude_range}}, \code{\link{none_of}},
  \code{\link{one_of}}, \code{\link{range}},
  \code{\link{some_of}}; \code{\link{at_least}},
  \code{\link{at_most}}, \code{\link{between}},
  \code{\link{counts}}, \code{\link{n}},
  \code{\link{n_times}}; \code{\link{group}};
  \code{\link{maybe}}, \code{\link{one_or_more}},
  \code{\link{wildcards}}, \code{\link{zero_or_more}},
  \code{\link{zero_or_one}}; \code{\link{not}};
  \code{\link{rex}}, \code{\link{rex_}};
  \code{\link{shortcuts}}
}

