% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pctCorrect.R
\name{pctCorrect}
\alias{pctCorrect}
\title{Percent Correctly Classified}
\usage{
pctCorrect(rf, pct = c(seq(0.8, 0.95, 0.05), 0.99))
}
\arguments{
\item{rf}{a \code{\link[randomForest]{randomForest}} or \code{rfPermute} object.}

\item{pct}{vector of minimum percent of trees voting for each class. Can be 
\code{0:1} or \code{0:100}.}
}
\value{
a matrix giving the percent of individuals correctly classified in 
  each class and overall for each threshold value specified in \code{pct}.
}
\description{
Calculate the percent of individuals correctly classified in 
  a specified percent of trees in the forest.
}
\examples{
data(mtcars)

rf <- randomForest(factor(am) ~ ., mtcars, importance = TRUE)
pctCorrect(rf)

}
\author{
Eric Archer \email{eric.archer@noaa.gov}
}

