% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotInbag.R
\name{plotInbag}
\alias{plotInbag}
\title{Plot inbag distribution}
\usage{
plotInbag(rf, sampsize = NULL, bins = 20, plot = TRUE)
}
\arguments{
\item{rf}{an object inheriting from \code{\link{randomForest}}.}

\item{sampsize}{optional vector of sample sizes used in \code{rf} model.}

\item{bins}{number of bins in histogram.}

\item{plot}{display the plot?}
}
\value{
the \code{ggplot2} object is invisibly returned. The red vertical 
  lines mark the expected values for the classes in the model based on their 
  frequency and sample sizes.
}
\description{
Plot distribution of sample inbag rates
}
\examples{
data(mtcars)

rf <- randomForest(factor(am) ~ ., mtcars)
plotInbag(rf)

}
\author{
Eric Archer \email{eric.archer@noaa.gov}
}
