% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distribution.R
\name{species_by_ecosystem}
\alias{species_by_ecosystem}
\title{Species list by ecosystem}
\usage{
species_by_ecosystem(
  ecosystem,
  species_list = NULL,
  server = getOption("FISHBASE_API", "fishbase"),
  version = get_latest_release(),
  db = default_db(),
  ...
)
}
\arguments{
\item{ecosystem}{(character) an ecosystem name}

\item{species_list}{A vector of scientific names (each element as "genus species"). If empty, a table for all fish will be returned.}

\item{server}{can be set to either "fishbase" or "sealifebase" to switch between databases. NOTE: it is usually
easier to leave this as NULL and set the source instead using the environmental variable `FISHBASE_API`, e.g.
`Sys.setenv(FISHBASE_API="sealifebase")`.}

\item{version}{a version string for the database, will default to the latest release. see [get_releases()] for details.}

\item{db}{the}

\item{...}{unused; for backwards compatibility only}
}
\value{
a table of species ecosystems data
}
\description{
Species list by ecosystem
}
\examples{
\dontshow{if (interactive() ) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
\dontrun{
species_by_ecosystem(ecosystem = "Arctic", server = "sealifebase")
}
\dontshow{\}) # examplesIf}
}
