% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/KeywordProcessor.R
\name{KeywordProcessor}
\alias{KeywordProcessor}
\title{FlashText algorithm to find and replace words}
\description{
Based on the python library \href{https://github.com/vi3k6i5/flashtext}{flashtext}. To see more details about the algorithm visit: \href{https://arxiv.org/abs/1711.00046}{FlashText}
}
\examples{
library(rflashtext)

processor <- KeywordProcessor$new(keys = c("NY", "LA"), words = c("New York", "Los Angeles"))

processor$contain_keys(keys = "NY")
processor$get_words(keys = "LA")

processor$find_keys(sentences = "I live in LA but I like NY")
processor$replace_keys(sentences = "I live in LA but I like NY")

## ------------------------------------------------
## Method `KeywordProcessor$new`
## ------------------------------------------------

library(rflashtext)

processor <- KeywordProcessor$new(keys = c("NY", "LA"), words = c("New York", "Los Angeles"))
processor$attrs
library(rflashtext)

processor <- KeywordProcessor$new(chars = paste0(letters, collapse = ""), keys = c("NY", "LA"))
processor$attrs

## ------------------------------------------------
## Method `KeywordProcessor$show_trie`
## ------------------------------------------------

library(rflashtext)

processor <- KeywordProcessor$new(keys = c("NY", "LA"), words = c("New York", "Los Angeles"))
processor$show_trie()

## ------------------------------------------------
## Method `KeywordProcessor$add_keys_words`
## ------------------------------------------------

library(rflashtext)

processor <- KeywordProcessor$new(keys = c("NY", "LA"), words = c("New York", "Los Angeles"))
processor$add_keys_words(keys = "CA", words = "California")
processor$show_trie()

## ------------------------------------------------
## Method `KeywordProcessor$contain_keys`
## ------------------------------------------------

library(rflashtext)

processor <- KeywordProcessor$new(keys = c("NY", "LA"), words = c("New York", "Los Angeles"))
processor$contain_keys(keys = c("NY", "LA", "TX"))

## ------------------------------------------------
## Method `KeywordProcessor$get_words`
## ------------------------------------------------

library(rflashtext)

processor <- KeywordProcessor$new(keys = c("NY", "LA"), words = c("New York", "Los Angeles"))
processor$get_words(keys = c("NY", "LA", "TX"))

## ------------------------------------------------
## Method `KeywordProcessor$find_keys`
## ------------------------------------------------

library(rflashtext)

processor <- KeywordProcessor$new(keys = c("NY", "LA"), words = c("New York", "Los Angeles"))
words_found <- processor$find_keys(sentences = "I live in LA but I like NY")
words_found

## ------------------------------------------------
## Method `KeywordProcessor$replace_keys`
## ------------------------------------------------

library(rflashtext)

processor <- KeywordProcessor$new(keys = c("NY", "LA"), words = c("New York", "Los Angeles"))
new_sentences <- processor$replace_keys(sentences = "I live in LA but I like NY")
new_sentences
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{attrs}}{list. Stores the attributes of the \code{KeywordProcessor} object.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-KeywordProcessor-new}{\code{KeywordProcessor$new()}}
\item \href{#method-KeywordProcessor-show_trie}{\code{KeywordProcessor$show_trie()}}
\item \href{#method-KeywordProcessor-add_keys_words}{\code{KeywordProcessor$add_keys_words()}}
\item \href{#method-KeywordProcessor-contain_keys}{\code{KeywordProcessor$contain_keys()}}
\item \href{#method-KeywordProcessor-get_words}{\code{KeywordProcessor$get_words()}}
\item \href{#method-KeywordProcessor-find_keys}{\code{KeywordProcessor$find_keys()}}
\item \href{#method-KeywordProcessor-replace_keys}{\code{KeywordProcessor$replace_keys()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-KeywordProcessor-new"></a>}}
\if{latex}{\out{\hypertarget{method-KeywordProcessor-new}{}}}
\subsection{Method \code{new()}}{
Initializes the \code{KeywordProcessor} object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{KeywordProcessor$new(
  keys = NULL,
  words = NULL,
  trie = NULL,
  id = "_word_",
  chars = paste0(c(letters, LETTERS, 0:9, "_"), collapse = ""),
  ignore_case = FALSE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{keys}}{character vector. Strings to identify (find/replace) in the text. Must be provided if \code{trie} is \code{NULL}.}

\item{\code{words}}{character vector. Strings to be returned (find) or replaced (replace) when found the respective \code{keys}. Should have the same length as \code{keys}. If not provided, \code{words = keys}.}

\item{\code{trie}}{character. JSON built character by character and needed for the search. It can be provided instead of \code{keys} and \code{words}.}

\item{\code{id}}{character. Used to name the end nodes of the \code{trie} dictionary.}

\item{\code{chars}}{character. Used to validate if a word continues. Default \code{paste0(c(letters, LETTERS, 0:9, "_"), collapse = "")} equivalent to \verb{[a-zA-Z0-9_]}.}

\item{\code{ignore_case}}{logical. If \code{FALSE} the search is case sensitive. Default \code{TRUE}.}
}
\if{html}{\out{</div>}}
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{library(rflashtext)

processor <- KeywordProcessor$new(keys = c("NY", "LA"), words = c("New York", "Los Angeles"))
processor$attrs
}
\if{html}{\out{</div>}}

\if{html}{\out{<div class="r example copy">}}
\preformatted{library(rflashtext)

processor <- KeywordProcessor$new(chars = paste0(letters, collapse = ""), keys = c("NY", "LA"))
processor$attrs
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-KeywordProcessor-show_trie"></a>}}
\if{latex}{\out{\hypertarget{method-KeywordProcessor-show_trie}{}}}
\subsection{Method \code{show_trie()}}{
Shows the \code{trie} dictionary used to find/replace \code{keys}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{KeywordProcessor$show_trie()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
character. JSON string of the \code{trie} structure. It can be converted to list using \code{jsonlite::fromJSON}.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{library(rflashtext)

processor <- KeywordProcessor$new(keys = c("NY", "LA"), words = c("New York", "Los Angeles"))
processor$show_trie()
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-KeywordProcessor-add_keys_words"></a>}}
\if{latex}{\out{\hypertarget{method-KeywordProcessor-add_keys_words}{}}}
\subsection{Method \code{add_keys_words()}}{
Adds \code{keys} and \code{words} to the \code{trie} dictionary.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{KeywordProcessor$add_keys_words(keys, words = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{keys}}{character vector. Strings to identify (find/replace) in the text.}

\item{\code{words}}{character vector. Strings to be returned (find) or replaced (replace) when found the respective \code{keys}. Should have the same length as \code{keys}. If not provided, \code{words = keys}.}
}
\if{html}{\out{</div>}}
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{library(rflashtext)

processor <- KeywordProcessor$new(keys = c("NY", "LA"), words = c("New York", "Los Angeles"))
processor$add_keys_words(keys = "CA", words = "California")
processor$show_trie()
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-KeywordProcessor-contain_keys"></a>}}
\if{latex}{\out{\hypertarget{method-KeywordProcessor-contain_keys}{}}}
\subsection{Method \code{contain_keys()}}{
Checks if \code{keys} are in the \code{trie} dictionary.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{KeywordProcessor$contain_keys(keys)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{keys}}{character vector. Strings to check if already are in the search \code{trie} dictionary.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
logical vector. \code{TRUE} if the \code{keys} are in the search \code{trie} dictionary.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{library(rflashtext)

processor <- KeywordProcessor$new(keys = c("NY", "LA"), words = c("New York", "Los Angeles"))
processor$contain_keys(keys = c("NY", "LA", "TX"))
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-KeywordProcessor-get_words"></a>}}
\if{latex}{\out{\hypertarget{method-KeywordProcessor-get_words}{}}}
\subsection{Method \code{get_words()}}{
Gets the \code{words} for the \code{keys} found in the \code{trie} dictionary.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{KeywordProcessor$get_words(keys)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{keys}}{character vector. Strings to get back the respective \code{words}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
character vector. Respective \code{words}. If \code{keys} not found returns \code{NA_character_}.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{library(rflashtext)

processor <- KeywordProcessor$new(keys = c("NY", "LA"), words = c("New York", "Los Angeles"))
processor$get_words(keys = c("NY", "LA", "TX"))
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-KeywordProcessor-find_keys"></a>}}
\if{latex}{\out{\hypertarget{method-KeywordProcessor-find_keys}{}}}
\subsection{Method \code{find_keys()}}{
Finds \code{keys} in the sentences using the search \code{trie} dictionary.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{KeywordProcessor$find_keys(sentences, span_info = TRUE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{sentences}}{character vector. Text to find the \code{keys} previously defined.}

\item{\code{span_info}}{logical. \code{TRUE} to retrieve the \code{words} and the position of the matches. \code{FALSE} to only retrieve the \code{words}. Default \code{TRUE}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
list with the \code{words} corresponding to \code{keys} found in the \code{sentence}. Hint: Use \code{data.table::rbindlist(...)} to transform the list to a data frame.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{library(rflashtext)

processor <- KeywordProcessor$new(keys = c("NY", "LA"), words = c("New York", "Los Angeles"))
words_found <- processor$find_keys(sentences = "I live in LA but I like NY")
words_found
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-KeywordProcessor-replace_keys"></a>}}
\if{latex}{\out{\hypertarget{method-KeywordProcessor-replace_keys}{}}}
\subsection{Method \code{replace_keys()}}{
Replaces \code{keys} found in the sentences by the corresponding \code{words}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{KeywordProcessor$replace_keys(sentences)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{sentences}}{character vector. Text to replace the \code{keys} found by the corresponding \code{words}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
character vector. Text with the \code{keys} replaced by the respective \code{words}.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{library(rflashtext)

processor <- KeywordProcessor$new(keys = c("NY", "LA"), words = c("New York", "Los Angeles"))
new_sentences <- processor$replace_keys(sentences = "I live in LA but I like NY")
new_sentences
}
\if{html}{\out{</div>}}

}

}
}
