% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flexscan.R
\name{choropleth}
\alias{choropleth}
\title{Display choropleth map}
\usage{
choropleth(
  polygons,
  fls,
  col = palette(),
  region_color = "#F0F0F0",
  rank = 1:length(fls$cluster),
  pval = 1,
  ...
)
}
\arguments{
\item{polygons}{A SpatialPolygonsDataFrame.}

\item{fls}{An rflexscan object.}

\item{col}{A vector of colors for each cluster.}

\item{region_color}{Color of regions that are not included in any clusters.}

\item{rank}{An integer vector which specifies ranks of clusters to be displayed.}

\item{pval}{A threshold of P-value. Clusters with P-values of <\code{pval} will be displayed.}

\item{...}{Other parameters to be passed to plot function.}
}
\description{
Display choropleth map of detected clusters.
}
\details{
Clusters are colored using the current palette. Please use \link{palette}
function to specify colors of each cluster. Note that clusters with ranks
larger than the number of colors in the palette are not highlighted.
}
\examples{
\donttest{
# load sample data (North Carolina SIDS data)
library(sf)
library(spdep)
data("nc.sids")
sids.shp <- read_sf(system.file("shapes/sids.shp", package="spData")[1])

# calculate the expected numbers of cases
expected <- nc.sids$BIR74 * sum(nc.sids$SID74) / sum(nc.sids$BIR74)

# run FleXScan
fls <- rflexscan(x = nc.sids$x, y = nc.sids$y,
                 observed = nc.sids$SID74,
                 expected = expected,
                 name = rownames(nc.sids),
                 clustersize = 10,
                 nb = ncCR85.nb)

# display all clusters
choropleth(sids.shp, fls)

# display clusters with rank 1, 2 and 3
choropleth(sids.shp, fls, rank = c(1, 2, 3))

# display clusters of P-value <= 0.05
choropleth(sids.shp, fls, pval = 0.05)
}

}
\seealso{
\link{rflexscan}
}
