/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.nary.nvalue;

import gnu.trove.list.array.TIntArrayList;
import gnu.trove.set.hash.TIntHashSet;
import java.util.Random;
import org.chocosolver.solver.ICause;
import org.chocosolver.solver.Priority;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.solver.variables.events.IntEventType;
import org.chocosolver.solver.variables.events.PropagatorEventType;
import org.chocosolver.util.ESat;
import org.chocosolver.util.objects.setDataStructures.ISet;
import org.chocosolver.util.objects.setDataStructures.ISetIterator;
import org.chocosolver.util.objects.setDataStructures.SetFactory;
import org.chocosolver.util.objects.setDataStructures.SetType;
import org.chocosolver.util.tools.ArrayUtils;

public class PropNValue
extends Propagator<IntVar> {
    private static final int NO_WITNESS = -1;
    private final IntVar nValue;
    private final int n;
    private final int[] concernedValues;
    private final int[] witness;
    private final ISet mandatoryValues;
    private final ISet possibleValues;
    private final TIntArrayList listForRandomPick;
    private final Random rnd;

    public PropNValue(IntVar[] vars, IntVar nvalue) {
        super((Variable[])ArrayUtils.concat(vars, nvalue), (Priority)PropagatorPriority.LINEAR, true);
        this.rnd = new Random(((IntVar[])this.vars)[0].getModel().getSeed());
        this.nValue = nvalue;
        this.n = vars.length;
        TIntHashSet set = new TIntHashSet();
        int min = Integer.MAX_VALUE;
        for (int i = 0; i < vars.length; ++i) {
            int value = vars[i].getLB();
            while (value <= vars[i].getUB()) {
                set.add(value);
                min = Math.min(min, value);
                value = vars[i].nextValue(value);
            }
        }
        this.concernedValues = set.toArray();
        this.possibleValues = SetFactory.makeStoredSet(SetType.BITSET, min, this.model);
        this.mandatoryValues = SetFactory.makeStoredSet(SetType.BITSET, min, this.model);
        this.listForRandomPick = new TIntArrayList();
        this.witness = new int[this.concernedValues.length];
        for (int j = 0; j < this.witness.length; ++j) {
            this.possibleValues.add(this.concernedValues[j]);
            this.witness[j] = -1;
            this.selectRandomWitness(j);
        }
    }

    @Override
    public int getPropagationConditions(int vIdx) {
        if (vIdx < this.n) {
            return IntEventType.all();
        }
        return IntEventType.instantiation();
    }

    private int contains(int v) {
        for (int i = 0; i < this.concernedValues.length; ++i) {
            if (this.concernedValues[i] != v) continue;
            return i;
        }
        return -1;
    }

    private void instantiateTo(int idxVar, int value) {
        int idxConcernedValue = this.contains(value);
        this.mandatoryValues.add(((IntVar[])this.vars)[idxVar].getValue());
        this.witness[idxConcernedValue] = idxVar;
        for (int i = 0; i < this.concernedValues.length; ++i) {
            if (this.witness[i] != idxVar || this.concernedValues[i] == value) continue;
            this.selectRandomWitness(i);
        }
    }

    private void selectRandomWitness(int idxConcernedValue) {
        int value = this.concernedValues[idxConcernedValue];
        this.listForRandomPick.clear();
        for (int i = 0; i < this.n; ++i) {
            if (((IntVar[])this.vars)[i].isInstantiatedTo(value)) {
                this.mandatoryValues.add(value);
                this.witness[idxConcernedValue] = i;
                return;
            }
            if (!((IntVar[])this.vars)[i].contains(value)) continue;
            this.listForRandomPick.add(i);
        }
        if (this.listForRandomPick.size() == 0) {
            this.possibleValues.remove(value);
            this.witness[idxConcernedValue] = -1;
        } else {
            this.witness[idxConcernedValue] = this.listForRandomPick.getQuick(this.rnd.nextInt(this.listForRandomPick.size()));
        }
    }

    @Override
    public void propagate(int idxVarInProp, int mask) throws ContradictionException {
        if (idxVarInProp < this.n) {
            for (int j = 0; j < this.concernedValues.length; ++j) {
                if (this.witness[j] != idxVarInProp || ((IntVar[])this.vars)[idxVarInProp].contains(this.concernedValues[j])) continue;
                this.selectRandomWitness(j);
            }
            if (((IntVar[])this.vars)[idxVarInProp].isInstantiated()) {
                this.instantiateTo(idxVarInProp, ((IntVar[])this.vars)[idxVarInProp].getValue());
            }
        }
        this.forcePropagate(PropagatorEventType.CUSTOM_PROPAGATION);
    }

    @Override
    public void propagate(int evtmask) throws ContradictionException {
        int i;
        int value;
        if (PropagatorEventType.isFullPropagation(evtmask)) {
            this.nValue.updateUpperBound(Math.min(((IntVar[])this.vars).length - 1, this.concernedValues.length), (ICause)this);
            for (int j = 0; j < this.witness.length; ++j) {
                this.selectRandomWitness(j);
            }
        } else if (PropagatorEventType.isCustomPropagation(evtmask)) {
            ISetIterator iterator = this.possibleValues.iterator();
            while (iterator.hasNext()) {
                value = iterator.nextInt();
                int idxConcernedValue = this.contains(value);
                if (this.witness[idxConcernedValue] != -1 && ((IntVar[])this.vars)[this.witness[idxConcernedValue]].contains(this.concernedValues[idxConcernedValue])) continue;
                this.selectRandomWitness(idxConcernedValue);
            }
        }
        this.nValue.updateBounds(this.mandatoryValues.size(), this.possibleValues.size(), this);
        if (this.nValue.isInstantiatedTo(this.mandatoryValues.size())) {
            for (i = 0; i < this.n; ++i) {
                value = ((IntVar[])this.vars)[i].getLB();
                while (value <= ((IntVar[])this.vars)[i].getUB()) {
                    if (!this.mandatoryValues.contains(value)) {
                        ((IntVar[])this.vars)[i].removeValue(value, (ICause)this);
                    }
                    value = ((IntVar[])this.vars)[i].nextValue(value);
                }
            }
            this.setPassive();
        } else if (this.nValue.isInstantiatedTo(this.n)) {
            for (i = 0; i < this.witness.length; ++i) {
                if (this.witness[i] == -1 || !((IntVar[])this.vars)[this.witness[i]].isInstantiatedTo(this.concernedValues[i])) continue;
                for (int j = 0; j < this.n; ++j) {
                    if (j == this.witness[i]) continue;
                    ((IntVar[])this.vars)[j].removeValue(this.concernedValues[i], (ICause)this);
                    if (!((IntVar[])this.vars)[j].isInstantiated()) continue;
                    this.instantiateTo(j, ((IntVar[])this.vars)[j].getValue());
                }
            }
            this.nValue.updateBounds(this.mandatoryValues.size(), this.possibleValues.size(), this);
        }
    }

    @Override
    public ESat isEntailed() {
        int countMin = 0;
        int countMax = 0;
        for (int i = 0; i < this.concernedValues.length; ++i) {
            boolean possible = false;
            boolean mandatory = false;
            for (int v = 0; v < this.n; ++v) {
                if (!((IntVar[])this.vars)[v].contains(this.concernedValues[i])) continue;
                possible = true;
                if (!((IntVar[])this.vars)[v].isInstantiated()) continue;
                mandatory = true;
                break;
            }
            if (possible) {
                ++countMax;
            }
            if (!mandatory) continue;
            ++countMin;
        }
        if (countMin > ((IntVar[])this.vars)[this.n].getUB() || countMax < ((IntVar[])this.vars)[this.n].getLB()) {
            return ESat.FALSE;
        }
        if (this.isCompletelyInstantiated() && countMin == this.nValue.getValue()) {
            return ESat.TRUE;
        }
        return ESat.UNDEFINED;
    }
}

