% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/gbif_photos.r
\name{gbif_photos}
\alias{gbif_photos}
\title{View photos from GBIF.}
\usage{
gbif_photos(input, output = NULL, which = "table", browse = TRUE)
}
\arguments{
\item{input}{Input output from occ_search}

\item{output}{Output folder path. If not given uses temporary folder.}

\item{which}{One of map or table (default).}

\item{browse}{(logical) Browse output (default: TRUE)}
}
\description{
View photos from GBIF.
}
\details{
The max number of photos you can see when which="map" is ~160, so cycle through
if you have more than that.
}
\examples{
\dontrun{
(res <- occ_search(mediatype = 'StillImage', return = "media"))
gbif_photos(res)
gbif_photos(res, which='map')

res <- occ_search(scientificName = "Aves", mediatype = 'StillImage', return = "media", limit=150)
gbif_photos(res)
gbif_photos(res, output = '~/barfoo')
}
}

