% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/installations.r
\name{installations}
\alias{installations}
\title{Installations metadata.}
\usage{
installations(
  data = "all",
  uuid = NULL,
  query = NULL,
  identifier = NULL,
  identifierType = NULL,
  limit = 100,
  start = NULL,
  curlopts = list()
)
}
\arguments{
\item{data}{The type of data to get. One or more of: 'contact', 'endpoint',
'dataset', 'comment', 'deleted', 'nonPublishing', or the special 'all'.
Default: \code{'all'}}

\item{uuid}{UUID of the data node provider. This must be specified if data
is anything other than 'all'.}

\item{query}{Query nodes. Only used when \code{data='all'}. Ignored
otherwise.}

\item{identifier}{The value for this parameter can be a simple string or
integer, e.g. \code{identifier=120}. This parameter doesn't seem to work right
now.}

\item{identifierType}{Used in combination with the identifier parameter to
filter identifiers by identifier type. See details. This parameter doesn't
seem to work right now.}

\item{limit}{Number of records to return. Default: 100. Maximum: 1000.}

\item{start}{Record number to start at. Default: 0. Use in combination
with \code{limit} to page through results.}

\item{curlopts}{list of named curl options passed on to
\code{\link[crul]{HttpClient}}. see \code{curl::curl_options}
for curl options}
}
\description{
Installations metadata.
}
\details{
identifierType options:

\itemize{
\item {DOI} No description.
\item {FTP} No description.
\item {GBIF_NODE} Identifies the node (e.g: \code{DK} for Denmark, \code{sp2000}
for Species 2000).
\item {GBIF_PARTICIPANT} Participant identifier from the GBIF IMS
Filemaker system.
\item {GBIF_PORTAL} Indicates the identifier originated from an
auto_increment column in the portal.data_provider or portal.data_resource
table respectively.
\item {HANDLER} No description.
\item {LSID} Reference controlled by a separate system, used for example
by DOI.
\item {SOURCE_ID} No description.
\item {UNKNOWN} No description.
\item {URI} No description.
\item {URL} No description.
\item {UUID} No description.
}
}
\examples{
\dontrun{
installations(limit=5)
installations(query="france", limit = 25)
installations(uuid="b77901f9-d9b0-47fa-94e0-dd96450aa2b4")
installations(data='contact', uuid="2e029a0c-87af-42e6-87d7-f38a50b78201")
installations(data='endpoint', uuid="b77901f9-d9b0-47fa-94e0-dd96450aa2b4")
installations(data='dataset', uuid="b77901f9-d9b0-47fa-94e0-dd96450aa2b4")
installations(data='deleted', limit = 25)
installations(data='deleted', limit=2)
installations(data=c('deleted','nonPublishing'), limit=2)
installations(identifierType='DOI', limit=2)

# Pass on curl options
installations(data='deleted', curlopts = list(verbose=TRUE))
}
}
\references{
\url{http://www.gbif.org/developer/registry#installations}
}
