% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/derived_dataset.R
\name{derived_dataset}
\alias{derived_dataset}
\alias{derived_dataset_prep}
\title{Register a derived dataset for citation.}
\usage{
derived_dataset(
  citation_data = NULL,
  title = NULL,
  description = NULL,
  source_url = NULL,
  gbif_download_doi = NULL,
  user = NULL,
  pwd = NULL,
  curlopts = list()
)

derived_dataset_prep(
  citation_data = NULL,
  title = NULL,
  description = NULL,
  source_url = NULL,
  gbif_download_doi = NULL,
  user = NULL,
  pwd = NULL,
  curlopts = list()
)
}
\arguments{
\item{citation_data}{(required) A data.frame with \strong{two columns}. The first
column should be GBIF \strong{datasetkey uuids} and the second column should be
\strong{occurrence counts} from each of your datasets, representing the
contribution of each dataset to your final derived dataset.}

\item{title}{(required) The title for your derived dataset.}

\item{description}{(required) A description of the dataset. Perhaps
describing how it was created.}

\item{source_url}{(required) A link to where the dataset is stored.}

\item{gbif_download_doi}{(optional) A DOI from an original GBIF download.}

\item{user}{(required) Your GBIF username.}

\item{pwd}{(required) Your GBIF password.}

\item{curlopts}{a list of arguments to pass to curl.}
}
\value{
A list.
}
\description{
Register a derived dataset for citation.
}
\section{Usage}{

Create a \strong{citable DOI} for a dataset derived from GBIF mediated
occurrences.

\strong{Use-case (1)} your dataset was obtained with \code{occ_search()} and
never returned a \strong{citable DOI}, but you want to cite the data in a
research paper.

\strong{Use-case (2)} your dataset was obtained using \code{occ_download()} and you
got a DOI, but the data underwent extensive filtering using
\code{CoordinateCleaner} or some other cleaning pipeline. In this case be sure
to fill in your original \code{gbif_download_doi}.

\strong{Use-case (3)} your dataset was generated using a GBIF cloud export but
you want a DOI to cite in your research paper.

Use \code{derived_dataset} to create a custom citable meta-data description and
most importantly a DOI link between an external archive (e.g. Zenodo) and the
datasets involved in your research or analysis.

All fields (except \code{gbif_download_doi}) are required for the registration to
work.

We recommend that you run \code{derived_dataset_prep()} to check registration
details before making it final with \code{derived_dataset()}.
}

\section{Authentication}{

Some \code{rgbif} functions require your \strong{GBIF credentials}.

For the \code{user} and \code{pwd} parameters, you can set them in one of
three ways:
\enumerate{
\item Set them in your \code{.Renviron}/\code{.bash_profile} (or similar) file with the
names \code{GBIF_USER}, \code{GBIF_PWD}, and \code{GBIF_EMAIL}
\item Set them in your \code{.Rprofile} file with the names \code{gbif_user} and
\code{gbif_pwd}.
\item Simply pass strings to each of the parameters in the function
call.
}

We strongly recommend the \strong{first option} - storing your details as
environment variables - as it's the most widely used way to store secrets.

You can edit your \code{.Renviron} with \code{usethis::edit_r_environ()}.

After editing, your \code{.Renviron} file should look something like this...

GBIF_USER="jwaller"\cr
GBIF_PWD="fakepassword123"\cr
GBIF_EMAIL="jwaller@gbif.org"\cr

See \code{?Startup} for help.
}

\examples{
\dontrun{
data <- data.frame(
 datasetKey = c(
 "3ea36590-9b79-46a8-9300-c9ef0bfed7b8",
 "630eb55d-5169-4473-99d6-a93396aeae38",
 "806bf7d4-f762-11e1-a439-00145eb45e9a"),
 count = c(3, 1, 2781)
 )

## If output looks ok, run derived_dataset to register the dataset
 derived_dataset_prep(
 citation_data = data,
 title = "Test for derived dataset",
 description = "This data was filtered using a fake protocol",
 source_url = "https://zenodo.org/record/4246090#.YPGS2OgzZPY"
 )

#  derived_dataset(
#  citation_data = data,
#  title = "Test for derived dataset",
#  description = "This data was filtered using a fake protocol",
#  source_url = "https://zenodo.org/record/4246090#.YPGS2OgzZPY"
#  )

## Example with occ_search and dplyr
# library(dplyr)

# citation_data <- occ_search(taxonKey=212, limit=20)$data \%>\%
#   group_by(datasetKey) \%>\% 
#   count()

# # You would still need to upload your data to Zenodo or something similar 
# derived_dataset_prep(
#   citation_data = citation_data,
#   title="Bird data downloaded for test",
#   description="This data was downloaded using rgbif::occ_search and was 
#   later uploaded to Zenodo.",
#   source_url="https://zenodo.org/record/4246090#.YPGS2OgzZPY",
#   gbif_download_doi = NULL,
# )
}

}
\references{
\url{https://data-blog.gbif.org/post/derived-datasets/}
\url{https://www.gbif.org/derived-dataset/about}
}
