% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/occ_download_import.R
\name{occ_download_import}
\alias{occ_download_import}
\alias{as.download}
\alias{as.download.character}
\alias{as.download.download}
\title{Import a downloaded file from GBIF.}
\usage{
occ_download_import(
  x = NULL,
  key = NULL,
  path = ".",
  fill = FALSE,
  encoding = "UTF-8",
  ...
)

as.download(path = ".", key = NULL)

\method{as.download}{character}(path = ".", key = NULL)

\method{as.download}{download}(path = ".", key = NULL)
}
\arguments{
\item{x}{The output of a call to \code{occ_download_get}}

\item{key}{A key generated from a request, like that from
\code{occ_download}}

\item{path}{Path to unzip file to. Default: \code{"."} Writes to
folder matching zip file name}

\item{fill}{(logical) (default: \code{FALSE}). If \code{TRUE} then in case
the rows have unequal length, blank fields are implicitly filled.
passed on to \code{fill} parameter in \link[data.table:fread]{data.table::fread}.}

\item{encoding}{(character) encoding to read in data; passed to
\code{\link[data.table:fread]{data.table::fread()}}. default: "UTF-8". other allowed options:
"Latin-1" and "unknown". see \code{?data.table::fread} docs}

\item{...}{parameters passed on to \code{\link[data.table:fread]{data.table::fread()}}. See \code{fread}
docs for details. Some \code{fread} parameters that may be particular useful
here are: \code{select} (select which columns to read in; others are dropped),
\code{nrows} (only read in a certain number of rows)}
}
\value{
a tibble (data.frame)
}
\description{
Import a downloaded file from GBIF.
}
\details{
You can provide either x as input, or both key and path. We use
\code{\link[data.table:fread]{data.table::fread()}} internally to read data.
}
\note{
see \link{downloads} for an overview of GBIF downloads methods
}
\section{Problems reading data}{

You may run into errors when using \code{occ_download_import()}; most often
these are due to \code{\link[data.table:fread]{data.table::fread()}} not being able to parse the
\code{occurrence.txt} file correctly. The \code{fill} parameter passes down to
\code{\link[data.table:fread]{data.table::fread()}} and the \code{...} allows you to pass on any other
parameters that \code{\link[data.table:fread]{data.table::fread()}} accepts. Read the docs for \code{fread}
for help.
}

\section{countryCode result column and Namibia}{

The country code for Namibia is \code{"NA"}. Unfortunately in R an \code{"NA"} string
will be read in to R as an NA/missing. To avoid this, in this function
we read in the data, then convert an NA/missing values to the character
string \code{"NA"}. When a country code is truly missing it will be an empty
string.
}

\examples{
\dontrun{
# First, kick off at least 1 download, then wait for the job to be complete
# Then use your download keys
res <- occ_download_get(key="0000066-140928181241064", overwrite=TRUE)
occ_download_import(res)

occ_download_get(key="0000066-140928181241064", overwrite = TRUE) \%>\%
  occ_download_import

# coerce a file path to the right class to feed to occ_download_import
# as.download("0000066-140928181241064.zip")
# as.download(key = "0000066-140928181241064")
# occ_download_import(as.download("0000066-140928181241064.zip"))

# download a dump that has a CSV file
# res <- occ_download_get(key = "0001369-160509122628363", overwrite=TRUE)
# occ_download_import(res)
# occ_download_import(key = "0001369-160509122628363")

# download and import a species list (in csv format)
# x <- occ_download_get("0000172-190415153152247")
# occ_download_import(x)
}
}
\seealso{
Other downloads: 
\code{\link{download_predicate_dsl}},
\code{\link{occ_download_cached}()},
\code{\link{occ_download_cancel}()},
\code{\link{occ_download_dataset_activity}()},
\code{\link{occ_download_datasets}()},
\code{\link{occ_download_get}()},
\code{\link{occ_download_list}()},
\code{\link{occ_download_meta}()},
\code{\link{occ_download_queue}()},
\code{\link{occ_download_wait}()},
\code{\link{occ_download}()}
}
\concept{downloads}
