#' Get Account Details For An Account
#'
#' @name account
#'
#' @description This is an auth based function. User must have valid api keys generated by GADX which must be passed as mandatory arguments. The function takes an account id as an additional input and returns the account details for that account. The account details currently include information about the currency (fiat or crypto) and the details on the balance (total, available and help for other transactions).
#'
#' @param acct_id Mandatory character value. This is case senstivite. Must be one of the \code{id} generated from \code{\link{accounts}}
#'
#' @param api.key Mandatory character value. This is the API key as generated by GDAX. Typically a 32 character value.
#' @param secret Mandatory character value. This is the API secret as generated by GDAX. Typically a 88 character value.
#' @param passphrase Mandatory character value. This is the passphrase as generated by GDAX. Typically a 11 character value.
#'
#' @return  Dataframe with a single row, provides the currency, the current balance, available, holds and profile_id of the user.
#'
#' @examples
#' \dontrun{
#' account(acct_id = "9kb58e27-276s-4g99-r2v7-128723948k1c",
#'        api.key = your_key, secret = your_api_secret, passphrase = your_api_pass)
#' }
#'
#' @export

account <- function(acct_id,
                    api.key,
                    secret,
                    passphrase) {
  #get url extension----
  req.url <-  paste0("/accounts/", acct_id)

  #define method----
  method <- "GET"

  #fetch response----
  response <- auth(
    method = method,
    req.url = req.url,
    api.key = api.key,
    secret = secret,
    passphrase = passphrase
  )

  #transform----
  response <- as.data.frame(response)

  #return----
  return(response)
}
