% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_order.R
\name{add_order}
\alias{add_order}
\alias{place_order}
\alias{post_order}
\title{Create a New Order For A Currency}
\usage{
add_order(api.key, secret, passphrase, product_id = "LTC-USD",
  type = "limit", stop = NULL, stop_price = NULL, side = "b",
  price = NULL, size)
}
\arguments{
\item{api.key}{Mandatory character value. This is the API key as generated by GDAX. Typically a 32 character value.}

\item{secret}{Mandatory character value. This is the API secret as generated by GDAX. Typically a 88 character value.}

\item{passphrase}{Mandatory character value. This is the passphrase as generated by GDAX. Typically a 11 character value.}

\item{product_id}{Optional character value for the currency pair. The default is \code{"LTC-USD"}. This param is case insensitive and must be one of the valid currency-pair. The list of valid currency-pairs can be fetched using \code{\link{public_info}}.}

\item{type}{Optional character value for the order type. The default is \code{"limit"}. This param is case insensitive and must be one of the valid order types. The current valid order types is only \code{"limit"}.}

\item{stop}{Optional parameter. This parameter is required if a stop order needs to be placed. Possible values apart from default \code{NULL} are \code{"loss"} or \code{"entry"}. If a non-default value is provided, \code{stop_price} argument must be defined.}

\item{stop_price}{Optional parameter.The value is needed only if \code{stop} is defined. Sets the trigger price for stop order. If \code{stop ="loss"}, the triger price is when market price is at or below the trigger. If \code{stop = "entry"}, the trigger price is when market price is at or above the trigger.}

\item{side}{Optional character value for the order side The default is \code{"b"} which stands for \code{buy}. This param is case insensitive and must be one of either \code{"b"} (buy) or \code{"s"} (sell).}

\item{price}{Conditional mandatory numeric value. It can either be an integer or float. Float values of greater than 2 decimals will be rounded to 2 decimals using the generic \code{round} function from R. The value is mandatory for \code{type = "limit"}.}

\item{size}{Mandatory numeric value. It can either be an integer or float. Float values will \bold{NOT} be rounded. The user must ensure that the fractional unit of a currency pair is valid for acceptance by GDAX. This information can also be determined by \code{\link{public_info}} which provides the minimun and maximum order sizes for each currency pairs.}
}
\value{
Dataframe with status of the order, posted details and created time stamp etc.
}
\description{
This is an auth based function. User must have valid api keys generated by GDAX which must be passed as mandatory arguments. The users can place different types of orders like \code{"limit"}, \code{"stop"} or \code{"market"}. Orders will be placed succesfully only if there is sufficient funds. Each order will result in a hold and the details of the hold can be tracked using \code{\link{holds}}. Margin Orders are currently not supported.
}
\examples{
\dontrun{
add_order("BTC-USD", api.key = your_key, secret = your_api_secret, passphrase = your_api_pass,
     type="limit", side = "s", price = 1000.25, size = 1)
}

}
