% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ee_utils.R
\name{ee_utils_cog_metadata}
\alias{ee_utils_cog_metadata}
\title{Return metadata of a COG tile server}
\usage{
ee_utils_cog_metadata(
  resource,
  visParams,
  titiler_server = "https://api.cogeo.xyz/"
)
}
\arguments{
\item{resource}{Character that represents a COG tile server file.}

\item{visParams}{Visualization parameters see "https://api.cogeo.xyz/docs".}

\item{titiler_server}{TiTiler endpoint. Defaults to "https://api.cogeo.xyz/".}
}
\value{
A metadata list for a COG file.
}
\description{
Return metadata of a COG tile server
}
\examples{
\dontrun{
 library(rgee)

server <- "https://s3-us-west-2.amazonaws.com/planet-disaster-data/hurricane-harvey/"
file <- "SkySat_Freeport_s03_20170831T162740Z3.tif"
resource <- paste0(server, file)
visParams <- list(nodata = 0, expression = "B3, B2, B1", rescale = "3000, 13500")
ee_utils_cog_metadata(resource, visParams)
}
}
