% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lisa.R
\docType{class}
\name{LISA-class}
\alias{LISA-class}
\alias{LISA}
\title{LISA class (Internally Used)}
\description{
A LISA-class that wrappers the statistics of LISA computation
}
\section{Fields}{

\describe{
\item{\code{gda_lisa}}{An object of GeoDaLISA}

\item{\code{p_vals}}{The pseudo-p values of significance of LISA computation}

\item{\code{c_vals}}{The cluster indicators of LISA computation}

\item{\code{lisa_vals}}{The local spatial autocorrelation values of LISA computation}

\item{\code{nn_vals}}{The number of neighbors of every observations in LISA computation}

\item{\code{lag_vals}}{The values of spatial lags of LISA computation}

\item{\code{num_obs}}{Number of observations}

\item{\code{labels}}{The cluster labels of LISA}

\item{\code{colors}}{The cluster colors (HEX format) of LISA}
}}

\section{Methods}{

\describe{
\item{\code{GetBO(current_p)}}{Get the Bonferroni bound value}

\item{\code{GetClusterIndicators()}}{Get the local cluster indicators returned from LISA computation.}

\item{\code{GetColors()}}{Get the cluster colors of LISA computation.}

\item{\code{GetFDR(current_p)}}{Get the False Discovery Rate value}

\item{\code{GetLISAValues()}}{Get the local spatial autocorrelation values returned from LISA computation.}

\item{\code{GetLabels()}}{Get the cluster labels of LISA computation.}

\item{\code{GetLocalSignificanceValues()}}{Get the local pseudo-p values of significance returned from LISA computation.}

\item{\code{GetNumNeighbors()}}{Get the number of neighbors of every observations in LISA computation.}

\item{\code{Run()}}{Call to run LISA computation}

\item{\code{SetPermutations(num_perm)}}{Set the number of permutations for the LISA computation}

\item{\code{SetSignificanceCutoff(cutoff)}}{Set the cutoff value of significance values}

\item{\code{SetThreads(num_threads)}}{Set the number of CPU threads for the LISA computation}

\item{\code{initialize(lisa_obj)}}{Constructor with a LISA object (internally used)}
}}

