% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{stddev_breaks}
\alias{stddev_breaks}
\title{Standard Deviation Breaks}
\usage{
stddev_breaks(df)
}
\arguments{
\item{df}{A data frame with selected variable. E.g. guerry["Crm_prs"]}
}
\value{
A vector of numeric values of computed breaks
}
\description{
Standard deviation breaks first transforms data to standard deviation units (mean=0, stddev=1), and then divide the range of values into 6 groups.
}
\examples{
library(sf)
guerry_path <- system.file("extdata", "Guerry.shp", package = "rgeoda")
guerry <- st_read(guerry_path)
stddev_breaks(guerry['Crm_prs'])
}
