% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lisa.R
\name{lisa_labels}
\alias{lisa_labels}
\title{Get cluster labels}
\usage{
lisa_labels(gda_lisa)
}
\arguments{
\item{gda_lisa}{An instance of LISA object}
}
\value{
A string vector of cluster labels
}
\description{
Get cluster labels of LISA computation.
}
\examples{
\dontrun{
guerry_path <- system.file("extdata", "Guerry.shp", package = "rgeoda")
guerry <- geoda_open(guerry_path)
queen_w <- queen_weights(guerry)
guerry_df <- as.data.frame(guerry) # use as data.frame
crm_prs <- guerry_df['Crm_prs'][,1] # get values of variable "crm_prs"
lisa <- local_moran(queen_w, crm_prs)
lbls <- lisa_labels(lisa)
lbls
}
}
