\name{edge.list}
\alias{edge.list}
\title{Decompose an edge list}
\description{Generates two data frames (nodes and edges) from a list of edges}
\usage{
edge.list(x)
}
\arguments{
  \item{x}{A matrix or data frame structured as a list of edges}
}
\details{
  \code{edge.list} transforms the input into a two-elements list containing a dataframe of nodes (with columns \dQuote{id} and \dQuote{label}) and a dataframe of edges. The last one is numeric (with columns \dQuote{source} and \dQuote{target}) and based on autogenerated nodes' ids. 
}
\value{
  A list containing two data frames.
}
\author{George Vega Yon \email{george.vega@nodoschile.org},

Jorge Fabrega Lacoa \email{jorge.fabrega@nodoschile.org}}
\examples{
  edgelist <- matrix(
    c("matthew","john",
      "max","stephen",
      "matthew","stephen"),
    byrow=TRUE, ncol=2)
  
  edge.list(edgelist)
}
\keyword{ manip }