% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rglobi.R
\name{get_interaction_matrix}
\alias{get_interaction_matrix}
\title{Get Interaction Matrix. Constructs an interaction matrix indicating whether source taxa (rows) or target taxa (columns) are known to interact with given type.}
\usage{
get_interaction_matrix(source.taxon.names = list("Homo sapiens"),
  target.taxon.names = list("Mammalia"), interaction.type = "eats",
  opts = list())
}
\arguments{
\item{source.taxon.names}{list of source taxon names (e.g. list('Mammalia', 'Aves', 'Ariopsis felis'))}

\item{target.taxon.names}{list of target taxon names}

\item{interaction.type}{the preferred interaction type (e.g. preysOn)}

\item{opts}{list of options to configure GloBI API}
}
\value{
matrix representing species interactions between source and target taxa
}
\description{
Get Interaction Matrix. Constructs an interaction matrix indicating whether source taxa (rows) or target taxa (columns) are known to interact with given type.
}
\examples{
\dontrun{
get_interaction_matrix("Homo sapiens", "Mammalia", "interactsWith")
}
}
\seealso{
Other interactions: \code{\link{get_child_taxa}},
  \code{\link{get_interaction_table}},
  \code{\link{get_interaction_types}},
  \code{\link{get_interactions_by_taxa}},
  \code{\link{get_interactions_by_type}},
  \code{\link{get_interactions}},
  \code{\link{get_predators_of}}, \code{\link{get_prey_of}}
}
\concept{interactions}
