% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/representation-kernel-methods.R
\name{PersistenceScaleSpaceKernel}
\alias{PersistenceScaleSpaceKernel}
\title{Kernel Representation: Persistence Scale-Space Kernel}
\description{
Computes the persistence scale space kernel matrix from a list
of persistence diagrams. The persistence scale space kernel is computed by
adding the symmetric to the diagonal of each point in each persistence
diagram, with negative weight, and then convolving the points with a
Gaussian kernel. See
https://www.cv-foundation.org/openaccess/content_cvpr_2015/papers/Reininghaus_A_Stable_Multi-Scale_2015_CVPR_paper.pdf
for more details.
}
\examples{
\dontshow{if (reticulate::py_module_available("gudhi")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
X <- seq_circle(10)
ac <- AlphaComplex$new(points = X)
st <- ac$create_simplex_tree()
dgm <- st$compute_persistence()$persistence_intervals_in_dimension(0)
ds <- DiagramSelector$new(use = TRUE)
dgm <- ds$apply(dgm)
pssk <- PersistenceScaleSpaceKernel$new()
pssk$apply(dgm, dgm)
pssk$fit_transform(list(dgm))
\dontshow{\}) # examplesIf}
}
\author{
Mathieu Carrière
}
\section{Super classes}{
\code{rgudhi::PythonClass} -> \code{rgudhi::SKLearnClass} -> \code{\link[rgudhi:KernelRepresentationStep]{rgudhi::KernelRepresentationStep}} -> \code{PersistenceScaleSpaceKernel}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-PersistenceScaleSpaceKernel-new}{\code{PersistenceScaleSpaceKernel$new()}}
\item \href{#method-PersistenceScaleSpaceKernel-clone}{\code{PersistenceScaleSpaceKernel$clone()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="rgudhi" data-topic="PythonClass" data-id="get_python_class"><a href='../../rgudhi/html/PythonClass.html#method-PythonClass-get_python_class'><code>rgudhi::PythonClass$get_python_class()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgudhi" data-topic="PythonClass" data-id="set_python_class"><a href='../../rgudhi/html/PythonClass.html#method-PythonClass-set_python_class'><code>rgudhi::PythonClass$set_python_class()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgudhi" data-topic="SKLearnClass" data-id="get_params"><a href='../../rgudhi/html/SKLearnClass.html#method-SKLearnClass-get_params'><code>rgudhi::SKLearnClass$get_params()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgudhi" data-topic="SKLearnClass" data-id="set_params"><a href='../../rgudhi/html/SKLearnClass.html#method-SKLearnClass-set_params'><code>rgudhi::SKLearnClass$set_params()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgudhi" data-topic="KernelRepresentationStep" data-id="apply"><a href='../../rgudhi/html/KernelRepresentationStep.html#method-KernelRepresentationStep-apply'><code>rgudhi::KernelRepresentationStep$apply()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgudhi" data-topic="KernelRepresentationStep" data-id="fit"><a href='../../rgudhi/html/KernelRepresentationStep.html#method-KernelRepresentationStep-fit'><code>rgudhi::KernelRepresentationStep$fit()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgudhi" data-topic="KernelRepresentationStep" data-id="fit_transform"><a href='../../rgudhi/html/KernelRepresentationStep.html#method-KernelRepresentationStep-fit_transform'><code>rgudhi::KernelRepresentationStep$fit_transform()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgudhi" data-topic="KernelRepresentationStep" data-id="transform"><a href='../../rgudhi/html/KernelRepresentationStep.html#method-KernelRepresentationStep-transform'><code>rgudhi::KernelRepresentationStep$transform()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PersistenceScaleSpaceKernel-new"></a>}}
\if{latex}{\out{\hypertarget{method-PersistenceScaleSpaceKernel-new}{}}}
\subsection{Method \code{new()}}{
The \code{\link{PersistenceScaleSpaceKernel}} constructor.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PersistenceScaleSpaceKernel$new(
  bandwidth = 1,
  kernel_approx = NULL,
  n_jobs = 1
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{bandwidth}}{A numeric value specifying the bandwidth of the Gaussian
kernel with which persistence diagrams will be convolved. Defaults to
\code{1.0}.}

\item{\code{kernel_approx}}{A Python class specifying the kernel approximation
class used to speed up computation. Defaults to \code{NULL}. Common kernel
approximations classes can be found in the \strong{scikit-learn} library
(such as \code{RBFSampler} for instance).}

\item{\code{n_jobs}}{An integer value specifying the number of jobs to use for
the computation. Defaults to \code{1}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
An object of class \code{\link{PersistenceScaleSpaceKernel}}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PersistenceScaleSpaceKernel-clone"></a>}}
\if{latex}{\out{\hypertarget{method-PersistenceScaleSpaceKernel-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PersistenceScaleSpaceKernel$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
