% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/representation-vector-methods.R
\name{TopologicalVector}
\alias{TopologicalVector}
\title{Vector Representation: Topological Vector}
\description{
Computes topological vectors from a list of persistence
diagrams. The topological vector associated to a persistence diagram is the
sorted vector of a slight modification of the pairwise distances between
the persistence diagram points. See
https://diglib.eg.org/handle/10.1111/cgf12692 for more details.
}
\examples{
\dontshow{if (reticulate::py_module_available("gudhi")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
X <- seq_circle(10)
ac <- AlphaComplex$new(points = X)
st <- ac$create_simplex_tree()
dgm <- st$compute_persistence()$persistence_intervals_in_dimension(0)
ds <- DiagramSelector$new(use = TRUE)
dgm <- ds$apply(dgm)
tv <- TopologicalVector$new()
tv$apply(dgm)
tv$fit_transform(list(dgm))
\dontshow{\}) # examplesIf}
}
\author{
Mathieu Carrière
}
\section{Super classes}{
\code{rgudhi::PythonClass} -> \code{rgudhi::SKLearnClass} -> \code{\link[rgudhi:VectorRepresentationStep]{rgudhi::VectorRepresentationStep}} -> \code{TopologicalVector}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-TopologicalVector-new}{\code{TopologicalVector$new()}}
\item \href{#method-TopologicalVector-clone}{\code{TopologicalVector$clone()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="rgudhi" data-topic="PythonClass" data-id="get_python_class"><a href='../../rgudhi/html/PythonClass.html#method-PythonClass-get_python_class'><code>rgudhi::PythonClass$get_python_class()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgudhi" data-topic="PythonClass" data-id="set_python_class"><a href='../../rgudhi/html/PythonClass.html#method-PythonClass-set_python_class'><code>rgudhi::PythonClass$set_python_class()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgudhi" data-topic="SKLearnClass" data-id="get_params"><a href='../../rgudhi/html/SKLearnClass.html#method-SKLearnClass-get_params'><code>rgudhi::SKLearnClass$get_params()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgudhi" data-topic="SKLearnClass" data-id="set_params"><a href='../../rgudhi/html/SKLearnClass.html#method-SKLearnClass-set_params'><code>rgudhi::SKLearnClass$set_params()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgudhi" data-topic="VectorRepresentationStep" data-id="apply"><a href='../../rgudhi/html/VectorRepresentationStep.html#method-VectorRepresentationStep-apply'><code>rgudhi::VectorRepresentationStep$apply()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgudhi" data-topic="VectorRepresentationStep" data-id="fit"><a href='../../rgudhi/html/VectorRepresentationStep.html#method-VectorRepresentationStep-fit'><code>rgudhi::VectorRepresentationStep$fit()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgudhi" data-topic="VectorRepresentationStep" data-id="fit_transform"><a href='../../rgudhi/html/VectorRepresentationStep.html#method-VectorRepresentationStep-fit_transform'><code>rgudhi::VectorRepresentationStep$fit_transform()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgudhi" data-topic="VectorRepresentationStep" data-id="transform"><a href='../../rgudhi/html/VectorRepresentationStep.html#method-VectorRepresentationStep-transform'><code>rgudhi::VectorRepresentationStep$transform()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TopologicalVector-new"></a>}}
\if{latex}{\out{\hypertarget{method-TopologicalVector-new}{}}}
\subsection{Method \code{new()}}{
The \code{\link{TopologicalVector}} constructor.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TopologicalVector$new(threshold = 10)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{threshold}}{An integer value specifying the number of distances to
keep. Defaults to \code{10L}. This is the dimension of the topological
vector. If \code{-1}, this threshold is computed from the list of
persistence diagrams by considering the one with the largest number of
points and using the dimension of its corresponding topological vector
as threshold.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
An object of class \code{\link{TopologicalVector}}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TopologicalVector-clone"></a>}}
\if{latex}{\out{\hypertarget{method-TopologicalVector-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TopologicalVector$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
