% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/representation-kernel-methods.R
\name{PersistenceSlicedWassersteinKernel}
\alias{PersistenceSlicedWassersteinKernel}
\title{Kernel Representation: Persistence Sliced Wasserstein Kernel}
\description{
Computes the sliced Wasserstein kernel matrix from a list of
persistence diagrams. The sliced Wasserstein kernel is computed by
exponentiating the corresponding sliced Wasserstein distance with a
Gaussian kernel. See http://proceedings.mlr.press/v70/carriere17a.html for
more details.
}
\examples{
\dontshow{if (reticulate::py_module_available("gudhi")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
X <- seq_circle(10)
ac <- AlphaComplex$new(points = X)
st <- ac$create_simplex_tree()
dgm <- st$compute_persistence()$persistence_intervals_in_dimension(0)
ds <- DiagramSelector$new(use = TRUE)
dgm <- ds$apply(dgm)
pswk <- PersistenceSlicedWassersteinKernel$new()
pswk$apply(dgm, dgm)
pswk$fit_transform(list(dgm))
\dontshow{\}) # examplesIf}
}
\author{
Mathieu Carrière
}
\section{Super classes}{
\code{rgudhi::PythonClass} -> \code{rgudhi::SKLearnClass} -> \code{\link[rgudhi:KernelRepresentationStep]{rgudhi::KernelRepresentationStep}} -> \code{PersistenceSlicedWassersteinKernel}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-PersistenceSlicedWassersteinKernel-new}{\code{PersistenceSlicedWassersteinKernel$new()}}
\item \href{#method-PersistenceSlicedWassersteinKernel-clone}{\code{PersistenceSlicedWassersteinKernel$clone()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="rgudhi" data-topic="PythonClass" data-id="get_python_class"><a href='../../rgudhi/html/PythonClass.html#method-PythonClass-get_python_class'><code>rgudhi::PythonClass$get_python_class()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgudhi" data-topic="PythonClass" data-id="set_python_class"><a href='../../rgudhi/html/PythonClass.html#method-PythonClass-set_python_class'><code>rgudhi::PythonClass$set_python_class()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgudhi" data-topic="SKLearnClass" data-id="get_params"><a href='../../rgudhi/html/SKLearnClass.html#method-SKLearnClass-get_params'><code>rgudhi::SKLearnClass$get_params()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgudhi" data-topic="SKLearnClass" data-id="set_params"><a href='../../rgudhi/html/SKLearnClass.html#method-SKLearnClass-set_params'><code>rgudhi::SKLearnClass$set_params()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgudhi" data-topic="KernelRepresentationStep" data-id="apply"><a href='../../rgudhi/html/KernelRepresentationStep.html#method-KernelRepresentationStep-apply'><code>rgudhi::KernelRepresentationStep$apply()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgudhi" data-topic="KernelRepresentationStep" data-id="fit"><a href='../../rgudhi/html/KernelRepresentationStep.html#method-KernelRepresentationStep-fit'><code>rgudhi::KernelRepresentationStep$fit()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgudhi" data-topic="KernelRepresentationStep" data-id="fit_transform"><a href='../../rgudhi/html/KernelRepresentationStep.html#method-KernelRepresentationStep-fit_transform'><code>rgudhi::KernelRepresentationStep$fit_transform()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgudhi" data-topic="KernelRepresentationStep" data-id="transform"><a href='../../rgudhi/html/KernelRepresentationStep.html#method-KernelRepresentationStep-transform'><code>rgudhi::KernelRepresentationStep$transform()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PersistenceSlicedWassersteinKernel-new"></a>}}
\if{latex}{\out{\hypertarget{method-PersistenceSlicedWassersteinKernel-new}{}}}
\subsection{Method \code{new()}}{
The \code{\link{PersistenceSlicedWassersteinKernel}} constructor.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PersistenceSlicedWassersteinKernel$new(
  num_directions = 10,
  bandwidth = 1,
  n_jobs = 1
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{num_directions}}{An integer value specifying the number of lines
evenly sampled from \eqn{[-\pi/2,\pi/2]} in order to approximate and
speed up the kernel computation. Defaults to \code{10L}.}

\item{\code{bandwidth}}{A numeric value specifying the bandwidth of the Gaussian
kernel with which persistence diagrams will be convolved. Defaults to
\code{1.0}.}

\item{\code{n_jobs}}{An integer value specifying the number of jobs to use for
the computation. Defaults to \code{1}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
An object of class \code{\link{PersistenceSlicedWassersteinKernel}}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PersistenceSlicedWassersteinKernel-clone"></a>}}
\if{latex}{\out{\hypertarget{method-PersistenceSlicedWassersteinKernel-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PersistenceSlicedWassersteinKernel$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
