% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/degree.R
\name{degree}
\alias{degree}
\title{Find the Degree of Vertices in a Hypergraph}
\usage{
degree(hype, method = "vertex")
}
\arguments{
\item{hype}{A hypergraph object}

\item{method}{The method for calculating degree. Out of \code{"vertex"},
\code{"vertex_simple"}, \code{"hyperedge"} and \code{"hyperedge_simple"}}
}
\value{
A vector representing the degree of each vertex with respect to the
given method.
}
\description{
The degree of a vertex is a way of expressing how many connections there
are from a vertex to the rest of the hypergraph. The current version of
rhype has three methods for computing degree.
}
\details{
\code{"vertex"} counts the number of ways it is possible to move to another
vertex. If there are multiple hyperedges connecting two vertices, then each
of these hyperedges will be counted as a new way to move between these two
vertices. For weighted hypergraphs or hypergraphs with real coefficients,
the strength of connection between two vertices is a functions of the weights
and real coefficients.

\code{"vertex_simple"} just counts the number of vertices it is possible to reach
in one step from the given vertex, no matter how many hyperedges connect them.

\code{"hyperedge"} represents the strength with which a vertex connects with
itself through the hyperedges it is a member of. This is taken from the work
of Jurgen Jost and Raffaella Mulas \doi{10.1016/j.aim.2019.05.025}. For
unweighted hypergraphs without real coefficients this is equivalent to
\code{"hyperedge_simple"}.

\code{"hyperedge_simple"} just counts the number of hyperedges a vertex is a
member of.
}
\examples{
h1 <- example_hype()
degree(h1)
}
