% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/example_hype.R
\name{example_hype}
\alias{example_hype}
\title{Generate an Example Hypergraph}
\usage{
example_hype(
  oriented = FALSE,
  directed = FALSE,
  vertex_weighted = FALSE,
  edge_weighted = FALSE,
  real_coef = FALSE
)
}
\arguments{
\item{oriented}{Logical value representing whether the example hypergraph
should be oriented}

\item{directed}{Logical value representing whether the example hypergraph
should be directed}

\item{vertex_weighted}{Logical value representing whether the example
hypergraph should have vertex weights}

\item{edge_weighted}{Logical value representing whether the example
hypergraph should have hyperedge weights}

\item{real_coef}{Logical value representing whether the example hypergraph
should have real coefficients relating vertices to hyperedges}
}
\value{
An example hypergraph with the given properties
}
\description{
Quickly generate an example hypergraph. Can be used for quickly testing and
trialing examples.
}
\examples{
h1 <- example_hype()
h2 <- example_hype(oriented = TRUE)
h3 <- example_hype(oriented = TRUE, directed = TRUE)
h4 <- example_hype(oriented = TRUE, directed = TRUE, real_coef = TRUE)
}
