% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dfmat.R
\name{removeInvarCol}
\alias{removeInvarCol}
\alias{isInvarCol}
\alias{isVarCol}
\title{Remove invariable columns from a data frame or matrix}
\usage{
removeInvarCol(df)
}
\arguments{
\item{df}{A data frame or matrix}
}
\value{
\code{isVarCol} and \code{isInvarCol} return a logical vector
indicating the variable and invariable columns respectively.

\code{removeInvarCol} removes invariable columns.
}
\description{
Columns with one unique value are invariable. The functions help to remove
such columns from a data frame (or matrix) in order to highlight the
variables.
}
\details{
\code{removeInvarCol} the data frame removing invariable column(s).

\code{isVarCol} and \code{isInvarCol} are helper functions, returning a
logical vector indicating the variable and invariable columns respectively.
}
\examples{

 testDf <- data.frame(a=1:4, b=7, c=LETTERS[1:4])
isVarCol(testDf)
isInvarCol(testDf)
removeInvarCol(testDf)

}
\author{
Jitao David Zhang <jitao_david.zhang@roche.com>
}
