% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prices.R
\name{riingo_crypto_prices}
\alias{riingo_crypto_prices}
\title{Get cryptocurrency prices aggregated through Tiingo}
\usage{
riingo_crypto_prices(
  ticker,
  start_date = NULL,
  end_date = NULL,
  resample_frequency = "1day",
  base_currency = NULL,
  exchanges = NULL,
  convert_currency = NULL,
  raw = FALSE
)
}
\arguments{
\item{ticker}{One or more cryptocurrency tickers.
Specified as \code{"btcusd"} for bitcoin quoted in USD. A character vector.}

\item{start_date}{The first date to download data for.
A character in the form YYYY-MM-DD, or a \code{Date} variable. The default is to
download 1 year's worth of data.}

\item{end_date}{The last date to download data for.
A character in the form YYYY-MM-DD, or a \code{Date} variable.}

\item{resample_frequency}{For Tiingo data, a character specified as one of:
\code{"daily"}, \code{"weekly"}, \code{"monthly"} or \code{"annually"}.

For IEX data, a character specified at the \code{"min"} or \code{"hour"} frequencies
in the form: \code{"1min"}, \code{"5min"}, or \code{"2hour"}.

For Crypto data, a character specified at the \code{"min"}, \code{"hour"} or \code{"day"}
frequencies similar to IEX.}

\item{base_currency}{\emph{Instead} of \code{ticker} you may pass a base currency.
This selects all currencies with that base currency.
For example if `base_currency="btc"`` tickers \emph{btcusd}, \emph{btcjpy}, \emph{btceur}, etc..
will all be returned.}

\item{exchanges}{If you would like to limit the query to a subset of exchanges,
pass a comma-separated list of exchanges to select. Example) \code{"POLONIEX, GDAX"}}

\item{convert_currency}{This parameter will convert the return data into another
fx rate. For example if querying \code{BTCUSD} and convert_currency is \code{'cure'},
the bitcoin prices will be converted to CureCoin prices.
Setting this to a value will add \code{fxOpen}, \code{fxHigh}, \code{fxLow}, \code{fxClose}, \code{fxVolumeNotional},
and \code{fxRate} accordingly. \code{fxRate} is the rate used to perform the currency calculation.
If \code{exchanges} is specified, the conversion rate will be calculated using the exchanges passed.}

\item{raw}{If \code{TRUE}, the raw underlying data from multiple exchanges will be
returned, rather than the clean prices. This is the data that calculates the aggregated prices and quotes.}
}
\description{
Get cryptocurrency prices aggregated through Tiingo
}
\examples{

\dontrun{

# Bitcoin prices
riingo_crypto_prices("btcusd")

# Bitcoin in USD and EUR
riingo_crypto_prices(c("btcusd", "btceur"), start_date = "2018-01-01", resample_frequency = "5min")

# Bitcoin raw data
riingo_crypto_prices("btcusd", raw = TRUE)

# Only use the POLONIEX exchange
riingo_crypto_prices("btcusd", raw = TRUE, exchanges = "POLONIEX")

# All btc___ crypotcurrency pairs
riingo_crypto_prices(base_currency = "btc")

}

}
