% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getCoxInfo.R
\name{CoxN}
\alias{CoxN}
\alias{CoxN.coxph}
\alias{CoxN.cph}
\alias{CoxN.phreg}
\title{Extract the number of observations from a Cox model}
\usage{
CoxN(object)

\method{CoxN}{cph}(object)

\method{CoxN}{coxph}(object)

\method{CoxN}{phreg}(object)
}
\arguments{
\item{object}{The fitted Cox regression model object either
obtained with \code{coxph} (survival package), \code{cph}
(rms package), or \code{phreg} (mets package).}
}
\description{
Extract the number of observations from a Cox model
}
\examples{
\dontrun{
d <- sampleData(1e2, outcome = "survival")
d$entry <- 0

##
library(survival)
mCox <- coxph(Surv(time, event) ~ X1+X2, data = d)
CoxN(mCox)

##
library(rms)
mCox <- cph(Surv(time, event) ~ X1+X2, data = d, y = TRUE)
CoxN(mCox)

##
library(mets)
mCox <- phreg(Surv(entry, time, event) ~ X1+X2, data = d)
CoxN(mCox)
}
}
\author{
Brice Ozenne broz@sund.ku.dk
}

