% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.predictCSC.R
\name{print.predictCSC}
\alias{print.predictCSC}
\title{Print predictions from a Cause-specific Cox proportional hazard regression}
\usage{
\method{print}{predictCSC}(x, digits = 3, ...)
}
\arguments{
\item{x}{object obtained with the function \code{predictCox}.}

\item{digits}{integer indicating the number of decimal places.}

\item{...}{Passed to print.}
}
\description{
Print predictions from a Cause-specific Cox proportional hazard regression
}
\examples{
## no strata
d <- sampleData(1e2, outcome = "competing.risks")
m.CSC <- CSC(Hist(time,event)~ X1 + X2 + X6, data = d)
pred.CSC <- predict(m.CSC, time = 1:5, cause = 1,
                      se = TRUE, keep.newdata = TRUE)

pred.CSC
print(pred.CSC, ci = TRUE)

## strata
library(survival)
m.SCSC <- CSC(Hist(time,event)~ strata(X1) + strata(X2) + X6,
              data = d)
pred.SCSC <- predict(m.SCSC, time = 1:5, cause = 1,
               se = TRUE, keep.newdata = TRUE, keep.strata = TRUE)
pred.SCSC
print(pred.SCSC, ci = TRUE)

}
