% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iptw_diagnostics.R
\name{create_balance_plots}
\alias{create_balance_plots}
\title{Create Balance Plots for IPTW Analysis}
\usage{
create_balance_plots(
  iptw_result,
  plot_type = "both",
  threshold = 0.1,
  save_plots = FALSE,
  plot_dir = "plots"
)
}
\arguments{
\item{iptw_result}{An iptw_result object from calc_iptw_weights()}

\item{plot_type}{Type of plot: "love" for standardized differences, "ps" for propensity score distributions, or "both"}

\item{threshold}{Threshold for acceptable standardized difference (default: 0.1)}

\item{save_plots}{Whether to save plots to files (default: FALSE)}

\item{plot_dir}{Directory to save plots if save_plots=TRUE (default: "plots")}
}
\value{
A ggplot object (if plot_type is "love" or "ps") or a list of ggplot objects (if plot_type is "both").
If ggplot2 is not available, returns a message and creates base R plots.
}
\description{
Creates visualizations to assess covariate balance before and after IPTW weighting.
Includes love plots (standardized differences) and propensity score distribution plots.
}
\details{
\subsection{Love Plot}{

Shows standardized differences for each covariate before and after weighting.
Points represent standardized differences, with lines connecting before/after values.
Horizontal lines show common thresholds (0.1, 0.25) for acceptable balance.
}

\subsection{Propensity Score Plot}{

Shows distributions of propensity scores by treatment group before and after weighting.
Good overlap indicates positivity assumption is met.
}
}
\examples{
\donttest{
data(cachar_sample)

# Calculate IPTW weights
iptw_result <- calc_iptw_weights(
  data = cachar_sample,
  treatment = "areca_nut",
  covariates = c("age", "sex", "residence", "smoking")
)

# Create balance plots
if (requireNamespace("ggplot2", quietly = TRUE)) {
  plots <- create_balance_plots(iptw_result, plot_type = "both")
  print(plots$love_plot)
  print(plots$ps_plot)
}
}

}
