% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/riskyr_class.R
\name{read_popu}
\alias{read_popu}
\title{Read a population (given as data frame) into a riskyr scenario.}
\usage{
read_popu(df = popu, ix_by_top = 1, ix_by_bot = 2, ix_sdt = 3,
  hi_lbl = txt$hi_lbl, mi_lbl = txt$mi_lbl, fa_lbl = txt$fa_lbl,
  cr_lbl = txt$cr_lbl, ...)
}
\arguments{
\item{df}{A data frame providing a population \code{\link{popu}}
of individuals, which are identified on at least
2 binary variables and classified into 4 cases in a 3rd variable.
Default: \code{df = \link{popu}} (as data frame).}

\item{ix_by_top}{Index of variable (column) providing the 1st (top) perspective (in df).
Default: \code{ix_by_top = 1} (1st column).}

\item{ix_by_bot}{Index of variable (column) providing the 2nd (bot) perspective (in df).
Default: \code{ix_by_bot = 2} (2nd column).}

\item{ix_sdt}{Index of variable (column) providing a classification into 4 cases (in df).
Default: \code{ix_by_bot = 3} (3rd column).}

\item{hi_lbl}{Variable label of cases classified as hi (TP).}

\item{mi_lbl}{Variable label of cases classified as mi (FN).}

\item{fa_lbl}{Variable label of cases classified as fa (FP).}

\item{cr_lbl}{Variable label of cases classified as cr (TN).}

\item{...}{Additional parameters (to be passed to \code{\link{riskyr}} function).}
}
\value{
An object of class "riskyr" describing a risk-related scenario.
}
\description{
\code{read_popu} interprets a data frame \code{df}
(that contains individual observations of some population)
and returns a scenario of class \code{"riskyr"}.
}
\details{
Note that \code{df} needs to be structured according to
the \code{\link{popu}} created by \code{\link{comp_popu}}.
}
\examples{
# Generating and interpreting different scenario types:

# (A) Diagnostic/screening scenario (using default labels): ------
popu_diag <- comp_popu(hi = 4, mi = 1, fa = 2, cr = 3)
# popu_diag
scen_diag <- read_popu(popu_diag, scen_lbl = "Diagnostics", popu_lbl = "Population tested")
plot(scen_diag, type = "prism", area = "no", f_lbl = "namnum")

# (B) Intervention/treatment scenario: ------
popu_treat <- comp_popu(hi = 80, mi = 20, fa = 45, cr = 55,
                        cond_lbl = "Treatment", cond_true_lbl = "pill", cond_false_lbl = "placebo",
                        dec_lbl = "Health status", dec_pos_lbl = "healthy", dec_neg_lbl = "sick")
# popu_treat
scen_treat <- read_popu(popu_treat, scen_lbl = "Treatment", popu_lbl = "Population treated")
plot(scen_treat, type = "prism", area = "sq", f_lbl = "namnum", p_lbl = "num")
plot(scen_treat, type = "icon", lbl_txt = txt_org, col_pal = pal_org)

# (C) Prevention scenario (e.g., vaccination): ------
popu_vacc <- comp_popu(hi = 960, mi = 40, fa = 880, cr = 120,
                       cond_lbl = "Vaccination", cond_true_lbl = "yes", cond_false_lbl = "no",
                       dec_lbl = "Disease", dec_pos_lbl = "no flu", dec_neg_lbl = "flu")
# popu_vacc
scen_vacc <- read_popu(popu_vacc, scen_lbl = "Prevention", popu_lbl = "Population vaccinated")
plot(scen_vacc, type = "prism", area = "sq", f_lbl = "namnum", col_pal = pal_bw, p_lbl = "num")

}
\seealso{
the corresponding data frame \code{\link{popu}};
the corresponding generating function \code{\link{comp_popu}};
\code{\link{riskyr}} initializes a \code{riskyr} scenario.

Other riskyr scenario functions: \code{\link{plot.riskyr}},
  \code{\link{riskyr}}, \code{\link{summary.riskyr}}
}
\concept{riskyr scenario functions}
