% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shortestroute_cleanup.R
\name{cleanup}
\alias{cleanup}
\title{Interactive Cleanup of a River Network}
\usage{
cleanup(rivers)
}
\arguments{
\item{rivers}{The river network object to use}
}
\value{
A new river network object with duplicated segments removed, see
  \link{rivernetwork}
}
\description{
This is the recommended function to use for cleanup of a river
  network.  It calls all available river network editing functions in
  appropriate sequence, detecting which are needed or recommended, and
  prompts user input wherever necessary.
  
  Currently, it automatically calls \link{removeduplicates}, prompts the user
  whether to run \link{dissolve}, automatically runs \link{removemicrosegs}
  and \link{splitsegments} if needed, provides user prompts for
  \link{addverts} and \link{setmouth}, detects if segments are unconnected
  and provides user prompts for \link{removeunconnected} or
  \link{connectsegs}, automatically runs \link{checkbraidedTF}, and prompts
  the user whether to run \link{buildsegroutes} if no braiding is detected.
}
\examples{
data(abstreams0,Koyukuk0,Kenai1)

# abstreams_fixed <- cleanup(abstreams0)
# Koyukuk <- cleanup(Koyukuk0)
# Kenai <- cleanup(Kenai1)
}
\author{
Matt Tyers
}
\seealso{
line2network
}

