% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apps_of_direction.R
\name{mouthdistbysurvey}
\alias{mouthdistbysurvey}
\title{Distance From Mouth for All Observations of Individuals}
\usage{
mouthdistbysurvey(unique, survey, seg, vert, rivers, logical = NULL,
  stopiferror = TRUE, algorithm = NULL)
}
\arguments{
\item{unique}{A vector of identifiers for each fish.}

\item{survey}{A vector of identifiers for each survey.  It is recommended to
use a numeric or date format (see \link{as.Date}) to preserve survey order.}

\item{seg}{A vector of river locations (segment)}

\item{vert}{A vector pf rover coordinates (vertex)}

\item{rivers}{The river network object to use}

\item{logical}{A boolean vector that can be used for subsetting - if used, 
\code{mouthdistbysurvey()} will only return distances in which a specified
condition is met.}

\item{stopiferror}{Whether or not to exit with an error if a route cannot be 
found.  If this is set to \code{FALSE} and a route cannot be found, the 
function will return \code{NA} in the appropriate entry.  Defaults to 
\code{TRUE}.  See \link{detectroute}.}

\item{algorithm}{Which route detection algorithm to use (\code{"Dijkstra"}, 
\code{"sequential"}, or \code{"segroutes"}).  If left as \code{NULL} (the 
default), the function will automatically make a selection.  See 
\link{detectroute} for more details.}
}
\value{
A vector of river network distances (numeric), with each row
  corresponding to a unique fish and each column corresponding to a unique
  survey.  Values of \code{NA} indicate the individual not being located
  during the survey in question.
}
\description{
Calculates distance from the mouth of a river network to all 
  observations of each individual (given as segment and vertex). and the 
  specified mouth of the river network.  The mouth must first be specified 
  (see \link{setmouth}).  Returns a matrix of distances, with a row for each 
  unique individual and a column for each survey.
  
  A plotting method is provided for the output; see \link{plotseq}.
}
\note{
Building routes from the river mouth to each river network segment and/or distance lookup tables will
  greatly reduce computation time (see \link{buildsegroutes}).
}
\examples{
data(Gulk, fakefish)

seqbysurvey <- mouthdistbysurvey(unique=fakefish$fish.id, survey=fakefish$flight.date, 
    seg=fakefish$seg, vert=fakefish$vert, rivers=Gulk)
seqbysurvey
plotseq(seqbysurvey)
}
\author{
Matt Tyers
}
\seealso{
\link{plotseq}
}

