% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/draw.R
\name{bglabel}
\alias{bglabel}
\title{Label with background}
\usage{
bglabel(
  x,
  y,
  text,
  bg = "#cccccc99",
  margin = 0.5,
  border = NA,
  pos = "center",
  cex = 1,
  ...
)
}
\arguments{
\item{x, y}{numeric vectors (coordinates)}

\item{text}{a character vector of labels}

\item{bg}{character vector; background color for the labels}

\item{margin}{numeric vector; margin (in percentage of a single character) for width and
height around the labels}

\item{border}{character vector; see \code{\link{rect}} for details}

\item{pos}{character vector; position where labels should be placed,
relative to the coordinates. Can be one of "topleft", "top", "topright",
"left", "center", "right", "bottomleft", "bottom" and "bottomright".}

\item{cex}{numeric vector; cex to be used for drawing the text}

\item{...}{any further parameters are passed to the \code{\link{text}} function}
}
\description{
Create a label with background
}
\details{
Creates a label with a background, a little extra margin (if necessary) etc.
}
