% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/route_wave_v4.r
\docType{data}
\name{waterolympics}
\alias{waterolympics}
\title{California Water Olympics}
\format{A data frame with 40 rows and 3 variables}
\usage{
data(waterolympics)
}
\description{
Digitized results from the California Water Olympics. The variables are as follows:
\itemize{
  \item t The time (in seconds) since the start of the model run.
  \item Q The flow rate [\eqn{ft^3 s^{-1}}].
  \item x The distance downstream [\eqn{ft}] at which the hydrograph was recorded.
}
The data can be used to validate numerical solutions to flood wave routing for a channel
under the following conditions:
\itemize{
  \item Channel width is 100 feet.
  \item Channel slope is 0.001.
  \item Channel extent is 150,000 feet.
  \item Channel roughness (Manning's n) is 0.045.
  \item Channel sideslope is 0 (rectangular channel).
  \item Initial flow rate is 250 cfs.
  \item Upstream boundary condition is defined as
    \deqn{Q(t < 9000) = 250 + \frac{750}{\pi}(1 - \cos{\frac{\pi t}{4500}})}
    \deqn{Q(t >= 9000) = 250}
}
}
\keyword{datasets}

