% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inclusionMax.R
\name{inclusionMax}
\alias{inclusionMax}
\title{Get inclusion maximal subsets from a list}
\usage{
inclusionMax(x, right = FALSE)
}
\arguments{
\item{x}{list containing the subsets}

\item{right}{logical indicating whether right-most entry is always inclusion maximal}
}
\description{
Get inclusion maximal subsets from a list
}
\details{
Returns the inclusion maximal elements of \code{x}.  The 
indicator \code{right} may be set to \code{TRUE} in order to indicate
that the right-most entry is always an inclusion maximal set over all earlier 
sets.
}
\examples{
letlist <- list(LETTERS[1:2], LETTERS[2:4], LETTERS[1:3])
inclusionMax(letlist)

}
