% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kernel.R
\name{MultiplicativeRQ.Kernel}
\alias{MultiplicativeRQ.Kernel}
\title{Multiplicative Rational Quadratic (RQ) Kernel}
\usage{
MultiplicativeRQ.Kernel(lengthscale, alpha = 1)
}
\arguments{
\item{lengthscale}{a vector for the positive length scale parameters}

\item{alpha}{a positive scalar for the scale mixture parameter that controls the relative weighting of large-scale and small-scale variations}
}
\value{
A Multiplicative Rational Quadratic (RQ) Kernel Class Object.
}
\description{
This function specifies the Multiplicative Rational Quadratic (RQ) kernel.
}
\details{
The Multiplicative Rational Quadratic (RQ) kernel is given by 
\deqn{k(r;\alpha)=\prod_{i=1}^{p}\left(1+\frac{r_{i}^2}{2\alpha}\right)^{-\alpha},}{k(r; alpha) = prod_{i=1}^{p}(1+[r_i^2/(2*alpha)])^{-alpha},}
where \eqn{\alpha}{alpha} is the scale mixture parameter and 
\deqn{r_{i}(x,x^{\prime})=\sqrt{\left(\frac{x_{i}-x_{i}^{\prime}}{l_{i}}\right)^2}}{r_i(x,x') = sqrt([(x_i - x'_i) / l_i]^2)} 
is the dimension-wise euclidean distances between \eqn{x}{x} and \eqn{x^{\prime}}{x'} weighted by
the length scale parameters \eqn{l_{i}}{l_i}'s.
}
\examples{
n <- 5
p <- 3
X <- matrix(rnorm(n*p), ncol=p)
lengthscale <- c(1:p)

# approach 1
kernel <- MultiplicativeRQ.Kernel(lengthscale, alpha=1)
Evaluate.Kernel(kernel, X)

# approach 2
kernel <- Get.Kernel(lengthscale, type="MultiplicativeRQ", parameters=list(alpha=1))
Evaluate.Kernel(kernel, X) 

}
\references{
Duvenaud, D. (2014). \emph{The kernel cookbook: Advice on covariance functions}.

Rasmussen, C. E. & Williams, C. K. (2006). \emph{Gaussian Processes for Machine Learning}. The MIT Press.
}
\seealso{
\link{RQ.Kernel}, \link{Get.Kernel}, \link{Evaluate.Kernel}.
}
\author{
Chaofan Huang and V. Roshan Joseph
}
