% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/state.R
\name{is_interactive}
\alias{is_interactive}
\alias{local_interactive}
\alias{with_interactive}
\title{Is R running interactively?}
\usage{
is_interactive()

local_interactive(value = TRUE, frame = caller_env())

with_interactive(expr, value = TRUE)
}
\arguments{
\item{value}{A single \code{TRUE} or \code{FALSE}. This overrides the return
value of \code{is_interactive()}.}

\item{frame}{The environment of a running function which defines
the scope of the temporary options. When the function returns,
the options are reset to their original values.}

\item{expr}{An expression to evaluate with interactivity set to
\code{value}.}
}
\description{
Like \code{\link[base:interactive]{base::interactive()}}, \code{is_interactive()} returns \code{TRUE} when
the function runs interactively and \code{FALSE} when it runs in batch
mode. It also checks, in this order:
\itemize{
\item The \code{rlang_interactive} global option. If set to a single \code{TRUE}
or \code{FALSE}, \code{is_interactive()} returns that value immediately. This
escape hatch is useful in unit tests or to manually turn on
interactive features in RMarkdown outputs.
\item Whether knitr, an RStudio notebook, or testthat is in progress
(in which case \code{is_interactive()} returns \code{FALSE}).
}

\code{with_interactive()} and \code{local_interactive()} set the global
option conveniently.
}
