% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/header_tools.r
\name{public_header_block_tools}
\alias{public_header_block_tools}
\alias{header_create}
\alias{header_update}
\title{Public Header Block Tools}
\usage{
header_create(data)

header_update(header, data)
}
\arguments{
\item{data}{data.frame or data.table}

\item{header}{list. A header}
}
\value{
A list containing the metadata required to write a las file.
}
\description{
Create or update a header for a las file from a dataset. A las file consists of two parts. A
header that describes the data and the data itself. These functions make valid headers (public
header block only) that can be used in \link{write.las}.
}
\details{
\code{header_create} makes a full header from data. \code{header_update} modifies the information that
needs to be updated. But most of the original information is not modified, for example point data
format is kept 'as is'.
}
\examples{
lasdata = data.frame(X = c(339002.889, 339002.983, 339002.918),
                     Y = c(5248000.515, 5248000.478, 5248000.318),
                     Z = c(975.589, 974.778, 974.471),
                     gpstime = c(269347.281418006, 269347.281428006, 269347.281438006),
                     Intensity = c(82L, 54L, 27L),
                     ReturnNumber = c(1L, 1L, 2L),
                     NumberOfReturns = c(1L, 1L, 2L),
                     ScanDirectionFlag = c(1L, 1L, 1L),
                     EdgeOfFlightline = c(1L, 0L, 0L),
                     Classification = c(1L, 1L, 1L),
                     ScanAngleRank = c(-21L, -21L, -21L),
                     UserData = c(32L, 32L, 32L),
                     PointSourceID = c(17L, 17L, 17L),
                     treeID = c(1L, 1L, 1L))

lasheader = header_create(lasdata)
}
\seealso{
Other header_tools: 
\code{\link{crs_tools}},
\code{\link{extra_bytes_attribute_tools}},
\code{\link{fwf_interpreter}()}
}
\concept{header_tools}
