% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lc.R
\name{lc_line}
\alias{lc_line}
\alias{lc_path}
\alias{lc_ribbon}
\alias{lc_abLine}
\alias{lc_hLine}
\alias{lc_vLine}
\title{Lines and ribbons}
\usage{
lc_line(
  data = list(),
  place = NULL,
  ...,
  chartId = NULL,
  layerId = NULL,
  addLayer = FALSE
)

lc_path(
  data = list(),
  place = NULL,
  ...,
  chartId = NULL,
  layerId = NULL,
  addLayer = FALSE
)

lc_ribbon(
  data = list(),
  place = NULL,
  ...,
  chartId = NULL,
  layerId = NULL,
  addLayer = FALSE
)

lc_abLine(
  data = list(),
  place = NULL,
  ...,
  chartId = NULL,
  layerId = NULL,
  addLayer = FALSE
)

lc_hLine(
  data = list(),
  place = NULL,
  ...,
  chartId = NULL,
  layerId = NULL,
  addLayer = FALSE
)

lc_vLine(
  data = list(),
  place = NULL,
  ...,
  chartId = NULL,
  layerId = NULL,
  addLayer = FALSE
)
}
\arguments{
\item{data}{Name value pairs of properties, passed through the \code{\link{dat}} function. These
properties will be reevaluated on each \code{\link{updateCharts}} call.}

\item{place}{ID of a container, where to place new chart. Will be ignored if the chart already
exists. If not defined, the chart will be appended to the body of the web pages.}

\item{...}{Name-value pairs of properties that will be evaluated only once and then will remain
constant. These properties can still be changed later using the \code{\link{setProperties}} function.}

\item{chartId}{ID for the chart. All charts must have unique IDs. If a chart with the same ID already
exists, it will be replaced unless \code{addLayer = TRUE}. If ID is not defined, it will be the same as
value of the \code{place} argument. And if both are not defined, the ID will be set to \code{ChartN},
where \code{N - 1} is the number of existing charts.}

\item{layerId}{An ID for the new layer. All layers within one chart must have different IDs. If a layer with the same
ID already exists, it will be replaced. If not defined, will be set to \code{LayerN}, where \code{N - 1}
is the number of currently existing layers in this chart.}

\item{addLayer}{if there is already a chart with the same ID, this argument defines whether to replace it or to add a
new layer to it. This argument is ignored if both \code{place} and \code{chartId} are \code{NULL} or if there is no
chart with the given ID.}
}
\description{
These functions create various kinds of lines. They connect observations or
create filled areas with customized border. Each layer may have one or several lines.
}
\section{Functions}{
\itemize{
\item \code{lc_line}: connects points in the order of variables on the x axis.

\item \code{lc_path}: connects points in the order they are given.

\item \code{lc_ribbon}: displays a filled area, defined by \code{ymax} and \code{ymin} values.

\item \code{lc_abLine}: creates straight lines by intercept and slope values

\item \code{lc_hLine}: creates horizontal lines by y-intercept values

\item \code{lc_vLine}: creates vertical lines by x-intercept values
}}

\section{Available properties}{

You can read more about different properties
\href{https://anders-biostat.github.io/linked-charts/rlc/tutorials/props.html}{here}.

\itemize{
\item \code{x, y} - vector of x and y coordinates of the points to connect. Can be
vectors for a single line or \code{m x n} matrix for \code{n} lines.
\item \code{ymax, ymin} - (only for \code{lc_ribbon}) vectors of maximal and minimal values for a ribbon.
\item \code{a, b} - (only for \code{lc_abLine}) vectors of slope and intercept values respectively.
\item \code{v} - (only for \code{lc_vLine}) vector of x-intercepts.
\item \code{h} - (only for \code{lc_hLine}) vector of y-intercepts.
\item \code{lineWidth} - (nor for \code{lc_ribbon}) width of each line.
\item \code{opacity} - opacity of each line in the range from 0 to 1.
\item \code{label} - vector of text labels for each line (labels by default are shown, when mouse hovers over a line).
\item \code{dasharray} - defines pattern of dashes and gaps for each line. }

Colour settings
\itemize{
\item \code{colour} - colour of the lines. Must be a colour name or hexadecimal code. For
\code{lc_ribbon} this property defines colour of the ribbon, not the strokes.
\item \code{fill} - (not for \code{lc_ribbon}) colour with which to fill area inside the line.
Must be a colour name or hexadecimal code.
\item \code{colourValue} - grouping values for different colours. Can be numbers or characters.
\item \code{colourDomain} - vector of all possible values for discrete colour scales
or range of all possible colour values for the continuous ones.
\item \code{palette} - vector of colours to construct the colour scale.
\item \code{colourLegendTitle} - title for the colour legend.
\item \code{addColourScaleToLegend} - whether or not to show colour legend for the current layer.
\item \code{globalColourScale} - whether or not to use one colour scale for all the layers.
\item \code{stroke} - (only for \code{lc_ribbon}) stroke colour for each ribbon.
Must be a colour name or hexadecimal code.
\item \code{strokeWidth} - (only for \code{lc_ribbon}) width of the strokes for each ribbon. }

Axes settings
\itemize{
\item \code{logScaleX, logScaleY} - a base of logarithm for logarithmic scale transformation.
If 0 or \code{FALSE} no transformation will be performed.
\item \code{layerDomainX, layerDomainY} - default axes ranges for the given layer.
\item \code{domainX, domainY} - default axes ranges for the entire chart. If not defined,
is automatically set to include all layer domains.
\item \code{contScaleX, contScaleY} - whether or not the axis should be continuous.
\item \code{aspectRatio} - aspect ratio.
\item \code{axisTitleX, axisTitleY} - axes titles.
\item \code{axisTitlePosX, axisTitlePosY} - position of axes titles. For each axis one can specify title position
across or along the corresponding axis. Possible options are \code{"up"} (for title inside the plotting area)
or \code{"down"} (outside the plotting area, under the axis), and
\code{"start"}, \code{"middle"}, \code{"end"}. This property must be a string with one or two of the abovementioned options
(e.g. \code{"middle down"}, \code{"start"}, etc.).
\item \code{ticksRotateX, ticksRotateY} - angle by which to rotate ticks (in degrees). Must be between
0 (horizontal ticks, default) and 90 (vertical ticks).
\item \code{ticksX, ticksY} - set of ticks for the axes.}

Interactivity settings
\itemize{
\item \code{on_click} - function, to be called, when one of the lines is clicked. Gets an
index of the clicked line as an argument.
\item \code{on_mouseover} - function, to be called, when mouse hovers over one of the lines.
Gets an index of the clicked line as an argument.
\item \code{on_mouseout} - function, to be called, when mouse moves out of one of the lines.
\item \code{on_marked} - function, to be called, when any of the lines are selected (marked)
or deselected. Use \code{\link{getMarked}} function to get the IDs of the currently marked lines. To mark lines,
select them with your mouse while holding the \emph{Shift} key.}

Global chart settings
\itemize{
\item \code{width} - width of the chart in pixels.
\item \code{heigth} - height of the chart in pixels.
\item \code{plotWidth} - width of the plotting area in pixels.
\item \code{plotHeight} - height of the plotting area in pixels.
\item \code{paddings} - padding sizes in pixels. Must be a list with all the following fields:
\code{"top", "bottom", "left", "right"}.
\item \code{title} - title of the chart.
\item \code{titleX, titleY} - coordinates of the chart title.
\item \code{titleSize} - font-size of the chart title.
\item \code{showLegend} - whether or not to show the legend.
\item \code{showPanel} - whether of not to show the instrument panel (grey triangle in the upper-left corner of the chart).
\item \code{transitionDuration} - duration of the transitions between any two states of the chart. If 0,
no animated transition is shown. It can be useful to turn the transition off, when lots of frequent
changes happen to the chart.
}
}

\examples{
\donttest{x <- seq(0, 8, 0.2)
lc_line(dat(x = x, y = cbind(cos(x), sin(x)),
            aspectRatio = 1,
            colour = c("blue", "red"),
            dasharray = c("5", "1 5 5")))
            
points <- seq(0, 6.5, 0.1)
x <- cos(points)
y <- sin(points)
lc_path(dat(x = sapply(0:2, function(i) x + i), 
            y = sapply(0:2, function(i) y + i),
            fill = c("blue", "red", "black"),
            opacity = c(0.3, 0.5, 0.7)))
            
x <- seq(0, 5, 0.1)
y <- x*3 + rnorm(length(x), sd = 2)
fit <- lm(y ~ x)
pred <- predict(fit, data.frame(x = x), se.fit = TRUE)
lc_ribbon(dat(ymin = pred$fit - 1.96 * pred$se.fit,
              ymax = pred$fit + 1.96 * pred$se.fit,
              x = x,
              colour = "#555555"), chartId = "ribbonTest")
lc_scatter(dat(x = x, y = y), size = 2, chartId = "ribbonTest", addLayer = TRUE)
lc_abLine(dat(a = fit$coefficients[2], b = fit$coefficients[1]), 
          chartId = "ribbonTest", addLayer = TRUE)

lc_hLine(dat(h = seq(1, 9, 1), domainX = c(0, 10), domainY = c(0, 10)), chartId = "grid")
lc_vLine(dat(v = seq(1, 9, 1)), chartId = "grid", addLayer = TRUE)}

}
