% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lc.R
\name{lc_heatmap}
\alias{lc_heatmap}
\title{Create a heatmap}
\usage{
lc_heatmap(
  data = list(),
  place = NULL,
  ...,
  chartId = NULL,
  with = NULL,
  pacerStep = 50
)
}
\arguments{
\item{data}{Name value pairs of properties, passed through the \code{\link{dat}} function. These
properties will be re-evaluated on each \code{\link{updateCharts}} call.}

\item{place}{ID of a container, where to place new chart. Will be ignored if the chart already
exists. If not defined, the chart will be appended to the body of the web pages.}

\item{...}{Name-value pairs of properties that will be evaluated only once and then will remain
constant. These properties can still be changed later using the \code{\link{setProperties}} function.}

\item{chartId}{ID for the chart. All charts must have unique IDs. If a chart with the same ID already
exists, it will be replaced. If ID is not defined, it will be the same as
value of the \code{place} argument. And if both are not defined, the ID will be set to \code{ChartN},
where \code{N - 1} is the number of existing charts.}

\item{with}{A data set from which other properties should be taken. If the data set doesn't have a
column with the requested name, the variable will be searched for outside of the data set. Must be
a data.frame or a list.}

\item{pacerStep}{Time in ms between two consecutive calls of an \code{onmouseover} event. Prevents over-queueing in case
of cumbersome computations. May be important when the chart works in canvas mode.}
}
\description{
\code{lc_heatmap} creates a new heatmap. Unlike charts with axes, heatmaps do not have
any layers.
}
\section{Available properties}{

You can read more about different properties
\href{https://anders-biostat.github.io/linked-charts/rlc/tutorials/props.html}{here}.

\itemize{
\item \code{value} - matrix of values that will be displayed as a heatmap.
\item \code{rowLabel, colLabel} - vector of labels for all rows or columns.
\item \code{showDendogramRow, showDendogramCol} - whether to show dendrograms when rows or columns are
clustered. Even if these properties are set to \code{FALSE}, rows and columns can still be clustered.
\item \code{clusterRows, clusterCols} - whether rows or columns should be clustered. If these
properties are set to \code{FALSE}, rows and columns can still be clustered later using the instrument
panel.
\item \code{mode} - one of \code{"default", "svg", "canvas"}. Defines, whether to display heatmap as
an SVG or Canvas object. \code{"default"} mode switches between the two, turning heatmap into Canvas
image, when there are too many cell, and into SVG object otherwise.
\item \code{heatmapRow, heatmapCol} - default order of rows and columns of the heatmap.
\item \code{showValue} - if \code{TRUE}, values will be shown as text in each cell.
\item \code{informText} - text that appears when the mouse cursor moves over an element. Unlike \code{label},
completely overwrites the tooltip content with a custom HTML code. Must be a matrix of characters (HTML code
for each cell).}

Style settings
\itemize{
\item \code{rowTitle, colTilte} - titles for rows and columns (similar to axes titles).
\item \code{palette} - vector of colours to construct a colour scale.
\item \code{colourDomain} - domain of the colour scale. All values outside it will
be clamped to its edges.}

Interactivity settings
\itemize{
\item \code{on_click} - function, to be called, when one of the cells is clicked. Gets a vector of row and column indices
of the clicked cell as its arguments.
\item \code{on_mouseover} - function, to be called, when mouse hovers over one of the cells.
Gets a vector of row and column indices of the clicked cell as its arguments.
\item \code{on_mouseout} - function, to be called, when mouse moves away from one of the cells.
\item \code{on_marked} - function, to be called, when any of the cells are selected (marked)
or deselected. Use \code{\link{getMarked}} function to get the IDs of the currently marked cells. To mark cells,
select them with your mouse while holding the \emph{Shift} key.}

Legend settings
\itemize{
\item \code{legend_width} - width of the legend in pixels. The default value is 200.
\item \code{legend_height} - height of the legend in pixels. By default, it is equal to the height of the chart.
\item \code{legend_sampleHeight} - height of a single key of the legend in pixels. The default value is 20.
\item \code{legend_ncol} - number of columns to order several legends. By default, this is defined from the number
of legends to reach close to square shape.
\item \code{legend_container} - a DOM element of the web page where to place the legend. By default, the legend is
positioned to the right from the chart in a table cell specifically made for it. This should be a valid CSS selector.
If the specified element does not exist, the legend will be added to the body of the web page.}

Global chart settings
\itemize{
\item \code{width} - width of the chart in pixels.
\item \code{heigth} - height of the chart in pixels.
\item \code{plotWidth} - width of the plotting area in pixels.
\item \code{plotHeight} - height of the plotting area in pixels.
\item \code{paddings} - padding sizes in pixels. Must be a list with all the following fields:
\code{"top", "bottom", "left", "right"}.
\item \code{title} - title of the chart.
\item \code{titleX, titleY} - coordinates of the chart title.
\item \code{titleSize} - font-size of the chart title.
\item \code{showLegend} - whether or not to show the legend.
\item \code{showPanel} - whether of not to show the instrument panel (grey triangle in the upper-left corner of the chart).
\item \code{transitionDuration} - duration of the transitions between any two states of the chart. If 0,
no animated transition is shown. It can be useful to turn the transition off, when lots of frequent
changes happen to the chart.}
}

\examples{
\donttest{
library(RColorBrewer)
#create a test matrix
test <- cbind(sapply(1:10, function(i) c(rnorm(10, mean = 1, sd = 3), 
                                         rnorm(6, mean = 5, sd = 2), 
                                         runif(14, 0, 8))),
              sapply(1:10, function(i) c(rnorm(10, mean = 3, sd = 2), 
                                         rnorm(6, mean = 1, sd = 2), 
                                         runif(14, 0, 8))))
test[test < 0] <- 0
rownames(test) <- paste0("Gene", 1:30)
colnames(test) <- paste0("Sample", 1:20)

lc_heatmap(dat(value = test))

# when you want to cluster rows or columns, it can be
# a good idea to make bottom and right paddings larger to
# fit labels
lc_heatmap(dat(value = test),
           clusterRows = TRUE,
           clusterCols = TRUE,
           paddings = list(top = 50, left = 30, bottom = 75, right = 75))

lc_heatmap(dat(value = cor(test), 
               colourDomain = c(-1, 1),
               palette = brewer.pal(11, "RdYlBu")))}
}
