% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/connectivity.R
\name{IsBipartite}
\alias{IsBipartite}
\title{Checks if Graph is Bipartite}
\usage{
IsBipartite(arcSources, arcTargets, numNodes)
}
\arguments{
\item{arcSources}{Vector corresponding to the source nodes of a graph's
edges}

\item{arcTargets}{Vector corresponding to the destination nodes of a graph's
edges}

\item{numNodes}{The number of nodes in the graph}
}
\value{
A \code{logical} stating if the graph is bipartite
}
\description{
A bipartite graph is one whose nodes can be divided into two disjoint and
independent sets such that edges only connecte between those two sets and
not within a set.
}
\details{
See \url{https://lemon.cs.elte.hu/pub/doc/1.3.1/a00616.html#ga577db110d33bd487aaad5bfffb31c6f5}
for more information.
}
