% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PLotting_sample_paths_stable.R
\name{Path_array}
\alias{Path_array}
\title{Path array generator}
\usage{
Path_array(N, m, M, l, sigma)
}
\arguments{
\item{N}{a number of points of the lfsm.}

\item{m}{discretization. A number of points between two nearby motion points}

\item{M}{truncation parameter. A number of points at which the integral representing the definition of lfsm is calculated. So, after M points back we consider the rest of the integral to be 0.}

\item{l}{a list of parameters to expand}

\item{sigma}{Scale parameter of lfsm}
}
\value{
The returned value is a data frame containing paths and the corresponding values of alpha, H and frequency.
}
\description{
The function takes a list of parameters (alpha, H) and uses \code{\link{expand.grid}} to obtain all possible combinations of them.
Based on each combination, the function simulates an lfsm sample path. It is meant to be used in conjunction with function \code{\link{Plot_list_paths}}.
}
\examples{
l=list(H=c(0.2,0.8),alpha=c(1,1.8), freq="H")
arr<-Path_array(N=300,m=30,M=100,l=l,sigma=0.3)
str(arr)
head(arr)
}
