% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/KrigingClass.R
\name{logMargPost.Kriging}
\alias{logMargPost.Kriging}
\alias{logMargPost,Kriging,Kriging-method}
\title{Get logMargPost of Kriging Model}
\usage{
\method{logMargPost}{Kriging}(object, ...)
}
\arguments{
\item{object}{An S3 Kriging object.}

\item{...}{Not used.}
}
\value{
The logMargPost computed for fitted
    \eqn{\boldsymbol{theta}}{\theta}.
}
\description{
Get logMargPost of Kriging Model
}
\examples{
f <- function(x) 1 - 1 / 2 * (sin(12 * x) / (1 + x) + 2 * cos(7 * x) * x^5 + 0.7)
set.seed(123)
X <- as.matrix(runif(10))
y <- f(X)

k <- Kriging(y, X, kernel = "matern3_2", objective="LMP")
print(k)

logMargPost(k)
}
\author{
Yann Richet \email{yann.richet@irsn.fr}
}
