% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NoiseKrigingClass.R
\name{save.NoiseKriging}
\alias{save.NoiseKriging}
\alias{save,NoiseKriging,NoiseKriging-method}
\title{Save a NoiseKriging Model to a file storage}
\usage{
\method{save}{NoiseKriging}(object, filename, ...)
}
\arguments{
\item{object}{An S3 NoiseKriging object.}

\item{filename}{File name to save in.}

\item{...}{Not used.}
}
\value{
The loaded NoiseKriging object.
}
\description{
Save a NoiseKriging Model to a file storage
}
\examples{
f <- function(x) 1- 1 / 2 * (sin(12 * x) / (1 + x) + 2 * cos(7 * x)*x^5 + 0.7)
set.seed(123)
X <- as.matrix(runif(10))
y <- f(X) + X/10 * rnorm(nrow(X))

k <- NoiseKriging(y, (X/10)^2, X, "matern3_2")
print(k)

outfile = tempfile("k.json") 
save(k,outfile)
}
\author{
Yann Richet \email{yann.richet@irsn.fr}
}
